/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing.containers;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.testing.containers.BaseTestContainer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Network;

public class MinIOContainer
extends BaseTestContainer {
    private static final Logger log = Logger.get(MinIOContainer.class);
    public static final String DEFAULT_IMAGE = "minio/minio:RELEASE.2021-07-15T22-27-34Z";
    public static final String DEFAULT_HOST_NAME = "minio";
    public static final int MINIO_API_PORT = 4566;
    public static final int MINIO_CONSOLE_PORT = 4567;

    public static Builder builder() {
        return new Builder();
    }

    private MinIOContainer(String image, String hostName, Set<Integer> exposePorts, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int retryLimit) {
        super(image, hostName, exposePorts, filesToMount, envVars, network, retryLimit);
    }

    @Override
    protected void setupContainer() {
        super.setupContainer();
        this.withRunCommand((List<String>)ImmutableList.of((Object)"server", (Object)"--address", (Object)"0.0.0.0:4566", (Object)"--console-address", (Object)"0.0.0.0:4567", (Object)"/data"));
    }

    @Override
    protected void startContainer() {
        super.startContainer();
        log.info(String.format("MinIO container started with address for api: http://%s and console: http://%s", this.getMinioApiEndpoint().toString(), this.getMinioConsoleEndpoint().toString()));
    }

    public HostAndPort getMinioApiEndpoint() {
        return this.getMappedHostAndPortForExposedPort(4566);
    }

    public HostAndPort getMinioConsoleEndpoint() {
        return this.getMappedHostAndPortForExposedPort(4567);
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, MinIOContainer> {
        private Builder() {
            this.image = MinIOContainer.DEFAULT_IMAGE;
            this.hostName = MinIOContainer.DEFAULT_HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)4566, (Object)4567);
        }

        @Override
        public MinIOContainer build() {
            return new MinIOContainer(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

