/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing.docker;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.testing.Closeables;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.ContainerNotFoundException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.io.Closeable;
import java.net.Socket;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedConsumer;

public final class DockerContainer
implements Closeable {
    private static final Logger LOG = Logger.get(DockerContainer.class);
    private static final boolean DEBUG = false;
    private static final String HOST_IP = "127.0.0.1";
    private final String image;
    private final Map<String, String> environment;
    private DockerClient dockerClient;
    private String containerId;
    private Map<Integer, Integer> hostPorts;

    public DockerContainer(String image, List<Integer> ports, Map<String, String> environment, CheckedConsumer<HostPortProvider> healthCheck) {
        this.image = Objects.requireNonNull(image, "image is null");
        this.environment = ImmutableMap.copyOf(Objects.requireNonNull(environment, "environment is null"));
        try {
            this.startContainer(ports, healthCheck);
        }
        catch (Exception e) {
            Closeables.closeAllSuppress((Throwable)e, (Closeable[])new Closeable[]{this});
            throw new RuntimeException(e);
        }
    }

    private void startContainer(List<Integer> ports, CheckedConsumer<HostPortProvider> healthCheck) throws Exception {
        this.dockerClient = DefaultDockerClient.fromEnv().build();
        if (this.dockerClient.listImages(new DockerClient.ListImagesParam[]{DockerClient.ListImagesParam.byName((String)this.image)}).isEmpty()) {
            Preconditions.checkState((!this.image.endsWith("-SNAPSHOT") ? 1 : 0) != 0, (String)"Unavailable snapshot image %s, please build before running tests", (Object)this.image);
            LOG.info("Pulling image %s...", new Object[]{this.image});
            this.dockerClient.pull(this.image);
        }
        this.createContainer(ports);
        Preconditions.checkState((boolean)this.isContainerUp(), (Object)"Container was not started properly");
        LOG.info("Auto-assigned host ports are %s", new Object[]{this.hostPorts});
        this.waitForContainer(healthCheck);
    }

    private boolean isContainerUp() {
        try {
            return this.dockerClient.inspectContainer(this.containerId).state().running();
        }
        catch (ContainerNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createContainer(List<Integer> ports) throws Exception {
        LOG.info("Starting docker container from image %s", new Object[]{this.image});
        Map portBindings = (Map)ports.stream().collect(ImmutableMap.toImmutableMap(Object::toString, port -> ImmutableList.of((Object)PortBinding.create((String)HOST_IP, (String)"0"))));
        Set exposedPorts = (Set)ports.stream().map(Object::toString).collect(ImmutableSet.toImmutableSet());
        this.containerId = this.dockerClient.createContainer(ContainerConfig.builder().hostConfig(HostConfig.builder().portBindings(portBindings).build()).exposedPorts(exposedPorts).env((List)this.environment.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(ImmutableList.toImmutableList())).image(this.image).build()).id();
        LOG.info("Started docker container with id: %s", new Object[]{this.containerId});
        this.dockerClient.startContainer(this.containerId);
        this.calculateHostPorts(ports);
        this.waitForContainerPorts(ports);
    }

    private void waitForContainer(CheckedConsumer<HostPortProvider> healthCheck) {
        RetryPolicy retryPolicy = new RetryPolicy().withMaxDuration(Duration.of(10L, ChronoUnit.MINUTES)).withMaxAttempts(Integer.MAX_VALUE).abortOn(error -> !this.isContainerUp()).onRetry(event -> LOG.info(String.format("Waiting for container for %s [%s]...", this.image, event.getLastFailure()))).withDelay(Duration.of(10L, ChronoUnit.SECONDS));
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).run(() -> healthCheck.accept(this::getHostPort));
    }

    private void waitForContainerPorts(List<Integer> ports) {
        List hostPorts = (List)ports.stream().map(this::getHostPort).collect(ImmutableList.toImmutableList());
        RetryPolicy retryPolicy = new RetryPolicy().withMaxDuration(Duration.of(10L, ChronoUnit.MINUTES)).withMaxAttempts(Integer.MAX_VALUE).abortOn(error -> !this.isContainerUp()).withDelay(Duration.of(5L, ChronoUnit.SECONDS)).onRetry(event -> LOG.info("Waiting for ports %s that are exposed on %s on %s ...", new Object[]{ports, HOST_IP, hostPorts}));
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).run(() -> {
            Iterator iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                Socket socket = new Socket(HOST_IP, this.getHostPort(port));
                Throwable throwable = null;
                try {
                    Preconditions.checkState((boolean)socket.isConnected());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
        });
    }

    private void calculateHostPorts(List<Integer> ports) throws Exception {
        this.hostPorts = (Map)this.dockerClient.inspectContainer(this.containerId).networkSettings().ports().entrySet().stream().filter(entry -> ports.contains(DockerContainer.extractPort(entry))).collect(ImmutableMap.toImmutableMap(entry -> DockerContainer.extractPort(entry), entry -> ((Optional)((List)entry.getValue()).stream().peek(portBinding -> Preconditions.checkState((boolean)portBinding.hostIp().equals(HOST_IP), (String)"Unexpected port binding found: %s", (Object)portBinding)).map(PortBinding::hostPort).collect(MoreCollectors.toOptional())).map(Integer::parseInt).orElseThrow(() -> new IllegalStateException("Could not extract port mapping from: " + entry))));
    }

    public int getHostPort(int port) {
        Preconditions.checkArgument((boolean)this.hostPorts.keySet().contains(port), (String)"Port %s is not bound", (int)port);
        return this.hostPorts.get(port);
    }

    private static int extractPort(Map.Entry<String, List<PortBinding>> entry) {
        Preconditions.checkArgument((!entry.getKey().contains("/udp") ? 1 : 0) != 0, (Object)"UDP port binding is not supported");
        return Integer.parseInt(entry.getKey().replace("/tcp", ""));
    }

    private void removeContainer(String containerId) {
        try {
            LOG.info("Killing container %s", new Object[]{containerId});
            this.dockerClient.killContainer(containerId);
            this.dockerClient.removeContainer(containerId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.dockerClient == null) {
            return;
        }
        if (this.containerId != null) {
            this.removeContainer(this.containerId);
        }
        this.dockerClient.close();
        this.dockerClient = null;
    }

    private /* synthetic */ boolean lambda$startContainer$0(Container container) {
        return container.image().equals(this.image);
    }

    public static interface HostPortProvider {
        public int getHostPort(int var1);
    }
}

