/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions;

import com.facebook.airlift.concurrent.ThreadLocalCache;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.teradata.functions.dateformat.DateFormatParser;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.zone.ZoneRulesException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class TeradataDateFunctions {
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_PARSER_CACHE = new ThreadLocalCache(100, format -> DateFormatParser.createDateTimeFormatter(format.toStringUtf8(), DateFormatParser.Mode.PARSER));
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_FORMATTER_CACHE = new ThreadLocalCache(100, format -> DateFormatParser.createDateTimeFormatter(format.toStringUtf8(), DateFormatParser.Mode.FORMATTER));
    private static final Logger LOG = Logger.get(TeradataDateFunctions.class);
    private static final ZoneId[] ZONE_IDS = new ZoneId[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];

    private TeradataDateFunctions() {
    }

    @Description(value="Formats a timestamp")
    @ScalarFunction(value="to_char")
    @SqlType(value="varchar")
    public static Slice toChar(SqlFunctionProperties properties, @SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar") Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology(IsoChronology.INSTANCE).withZone(ZONE_IDS[DateTimeEncoding.unpackZoneKey((long)timestampWithTimeZone).getKey()]).withLocale(properties.getSessionLocale());
        return Slices.utf8Slice((String)formatter.format(Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone))));
    }

    @Description(value="Converts a string to a DATE data type")
    @ScalarFunction(value="to_date")
    @SqlType(value="date")
    public static long toDate(SqlFunctionProperties properties, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        try {
            long millis = TeradataDateFunctions.parseMillis(TimeZoneKey.UTC_KEY, properties.getSessionLocale(), dateTime, formatString);
            return TimeUnit.MILLISECONDS.toDays(millis);
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    @Description(value="Converts a string to a TIMESTAMP data type")
    @ScalarFunction(value="to_timestamp")
    @SqlType(value="timestamp")
    public static long toTimestamp(SqlFunctionProperties properties, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        return TeradataDateFunctions.parseMillis(properties, dateTime, formatString);
    }

    private static long parseMillis(SqlFunctionProperties properties, Slice dateTime, Slice formatString) {
        TimeZoneKey timeZoneKey = TimeZoneKey.UTC_KEY;
        if (properties.isLegacyTimestamp()) {
            timeZoneKey = properties.getTimeZoneKey();
        }
        return TeradataDateFunctions.parseMillis(timeZoneKey, properties.getSessionLocale(), dateTime, formatString);
    }

    private static long parseMillis(TimeZoneKey timeZoneKey, Locale locale, Slice dateTime, Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_PARSER_CACHE.get((Object)formatString)).withChronology(IsoChronology.INSTANCE).withZone(ZONE_IDS[timeZoneKey.getKey()]).withLocale(locale);
        try {
            return ZonedDateTime.parse(dateTime.toString(StandardCharsets.UTF_8), formatter).toInstant().toEpochMilli();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    static {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            try {
                TeradataDateFunctions.ZONE_IDS[timeZoneKey.getKey()] = ZoneId.of(timeZoneKey.getId());
            }
            catch (ZoneRulesException ex) {
                LOG.error((Throwable)ex, "Failed to obtain an instance of ZoneId for %s, ignoring this exception", new Object[]{timeZoneKey.getId()});
            }
        }
    }
}

