/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.ExecutionStrategy;
import java.util.List;
import java.util.Objects;

public class PrestoSparkFailure
extends RuntimeException {
    private final String type;
    private final String errorCode;
    private final StackTraceElement[] stackTrace;
    private final List<ExecutionStrategy> retryExecutionStrategies;

    public PrestoSparkFailure(String message, Throwable cause, String type, String errorCode, StackTraceElement[] stackTrace, List<ExecutionStrategy> retryExecutionStrategies) {
        super(message, cause);
        this.type = Objects.requireNonNull(type, "type is null");
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.stackTrace = Objects.requireNonNull(stackTrace, "stackTrace is null");
        this.retryExecutionStrategies = Objects.requireNonNull(retryExecutionStrategies, "retryExecutionStrategies is null");
    }

    public String getType() {
        return this.type;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public List<ExecutionStrategy> getRetryExecutionStrategies() {
        return this.retryExecutionStrategies;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append(":");
        String message = this.getMessage();
        if (message != null) {
            sb.append(message);
        }
        for (StackTraceElement element : this.stackTrace) {
            sb.append(" ").append(element).append("\n");
        }
        return sb.toString();
    }
}

