/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.system.SystemTablesManager;
import com.facebook.presto.metadata.FunctionFactory;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.OperatorFactory;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.ThreadContextClassLoader;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Injector;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.sonatype.aether.artifact.Artifact;

@ThreadSafe
public class PluginManager {
    private static final List<String> HIDDEN_CLASSES = ImmutableList.builder().add((Object)"org.slf4j").build();
    private static final ImmutableList<String> PARENT_FIRST_CLASSES = ImmutableList.builder().add((Object)"com.facebook.presto").add((Object)"com.fasterxml.jackson").add((Object)"io.airlift.slice").add((Object)"javax.inject").build();
    private static final Logger log = Logger.get(PluginManager.class);
    private final Injector injector;
    private final ConnectorManager connectorManager;
    private final SystemTablesManager systemTablesManager;
    private final MetadataManager metadataManager;
    private final BlockEncodingManager blockEncodingManager;
    private final TypeRegistry typeRegistry;
    private final ArtifactResolver resolver;
    private final File installedPluginsDir;
    private final List<String> plugins;
    private final Map<String, String> optionalConfig;
    private final AtomicBoolean pluginsLoaded = new AtomicBoolean();

    @Inject
    public PluginManager(Injector injector, NodeInfo nodeInfo, HttpServerInfo httpServerInfo, PluginManagerConfig config, ConnectorManager connectorManager, ConfigurationFactory configurationFactory, SystemTablesManager systemTablesManager, MetadataManager metadataManager, BlockEncodingManager blockEncodingManager, TypeRegistry typeRegistry) {
        Preconditions.checkNotNull((Object)injector, (Object)"injector is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull((Object)httpServerInfo, (Object)"httpServerInfo is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)configurationFactory, (Object)"configurationFactory is null");
        this.injector = injector;
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.plugins = config.getPlugins() == null ? ImmutableList.of() : ImmutableList.copyOf(config.getPlugins());
        this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
        TreeMap<String, String> optionalConfig = new TreeMap<String, String>(configurationFactory.getProperties());
        optionalConfig.put("node.id", nodeInfo.getNodeId());
        optionalConfig.put("http-server.http.port", Integer.toString(httpServerInfo.getHttpUri().getPort()));
        this.optionalConfig = ImmutableMap.copyOf(optionalConfig);
        this.connectorManager = (ConnectorManager)Preconditions.checkNotNull((Object)connectorManager, (Object)"connectorManager is null");
        this.systemTablesManager = (SystemTablesManager)Preconditions.checkNotNull((Object)systemTablesManager, (Object)"systemTablesManager is null");
        this.metadataManager = (MetadataManager)Preconditions.checkNotNull((Object)metadataManager, (Object)"metadataManager is null");
        this.blockEncodingManager = (BlockEncodingManager)Preconditions.checkNotNull((Object)blockEncodingManager, (Object)"blockEncodingManager is null");
        this.typeRegistry = (TypeRegistry)Preconditions.checkNotNull((Object)typeRegistry, (Object)"typeRegistry is null");
    }

    public boolean arePluginsLoaded() {
        return this.pluginsLoaded.get();
    }

    public void loadPlugins() throws Exception {
        if (!this.pluginsLoaded.compareAndSet(false, true)) {
            return;
        }
        for (File file : PluginManager.listFiles(this.installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            this.loadPlugin(file.getAbsolutePath());
        }
        for (String plugin : this.plugins) {
            this.loadPlugin(plugin);
        }
    }

    private void loadPlugin(String plugin) throws Exception {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        URLClassLoader pluginClassLoader = this.buildClassLoader(plugin);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(pluginClassLoader);){
            this.loadPlugin(pluginClassLoader);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    private void loadPlugin(URLClassLoader pluginClassLoader) throws Exception {
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        for (Plugin plugin : plugins) {
            this.installPlugin(plugin);
        }
    }

    public void installPlugin(Plugin plugin) {
        this.injector.injectMembers((Object)plugin);
        plugin.setOptionalConfig(this.optionalConfig);
        for (BlockEncodingFactory blockEncodingFactory : plugin.getServices(BlockEncodingFactory.class)) {
            this.blockEncodingManager.addBlockEncodingFactory(blockEncodingFactory);
        }
        for (Type type : plugin.getServices(Type.class)) {
            this.typeRegistry.addType(type);
        }
        for (ConnectorFactory connectorFactory : plugin.getServices(ConnectorFactory.class)) {
            this.connectorManager.addConnectorFactory(connectorFactory);
        }
        for (SystemTable systemTable : plugin.getServices(SystemTable.class)) {
            this.systemTablesManager.addTable(systemTable);
        }
        for (FunctionFactory functionFactory : plugin.getServices(FunctionFactory.class)) {
            this.metadataManager.addFunctions(functionFactory.listFunctions());
        }
        for (OperatorFactory operatorFactory : plugin.getServices(OperatorFactory.class)) {
            this.metadataManager.addOperators(operatorFactory.listOperators());
        }
    }

    private URLClassLoader buildClassLoader(String plugin) throws Exception {
        File file = new File(plugin);
        if (file.isFile() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return this.buildClassLoaderFromPom(file);
        }
        if (file.isDirectory()) {
            return this.buildClassLoaderFromDirectory(file);
        }
        return this.buildClassLoaderFromCoordinates(plugin);
    }

    private URLClassLoader buildClassLoaderFromPom(File pomFile) throws Exception {
        List artifacts = this.resolver.resolvePom(pomFile);
        log.debug("Classpath for %s:", new Object[]{pomFile});
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new File(pomFile.getParentFile(), "target/classes/").toURI().toURL());
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() != null) {
                log.debug("    %s", new Object[]{artifact.getFile()});
                urls.add(artifact.getFile().toURI().toURL());
                continue;
            }
            log.debug("  Could not resolve artifact %s", new Object[]{artifact});
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader buildClassLoaderFromDirectory(File dir) throws Exception {
        log.debug("Classpath for %s:", new Object[]{dir.getName()});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : PluginManager.listFiles(dir)) {
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader buildClassLoaderFromCoordinates(String coordinates) throws Exception {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        List artifacts = this.resolver.resolveArtifacts(new Artifact[]{rootArtifact});
        log.debug("Classpath for %s:", new Object[]{rootArtifact});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() != null) {
                log.debug("    %s", new Object[]{artifact.getFile()});
                urls.add(artifact.getFile().toURI().toURL());
                continue;
            }
            log.warn("  Could not resolve artifact %s", new Object[]{artifact});
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader createClassLoader(List<URL> urls) {
        ClassLoader parent = this.getClass().getClassLoader();
        return new SimpleChildFirstClassLoader(urls, parent, (Iterable<String>)HIDDEN_CLASSES, (Iterable<String>)PARENT_FIRST_CLASSES);
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static class SimpleChildFirstClassLoader
    extends URLClassLoader {
        private final List<String> hiddenClasses;
        private final List<String> parentFirstClasses;
        private final List<String> hiddenResources;
        private final List<String> parentFirstResources;

        public SimpleChildFirstClassLoader(List<URL> urls, ClassLoader parent, Iterable<String> hiddenClasses, Iterable<String> parentFirstClasses) {
            this(urls, parent, hiddenClasses, parentFirstClasses, Iterables.transform(hiddenClasses, SimpleChildFirstClassLoader.classNameToResource()), Iterables.transform(parentFirstClasses, SimpleChildFirstClassLoader.classNameToResource()));
        }

        public SimpleChildFirstClassLoader(List<URL> urls, ClassLoader parent, Iterable<String> hiddenClasses, Iterable<String> parentFirstClasses, Iterable<String> hiddenResources, Iterable<String> parentFirstResources) {
            super(urls.toArray(new URL[urls.size()]), (ClassLoader)Preconditions.checkNotNull((Object)parent, (Object)"parent is null"));
            this.hiddenClasses = ImmutableList.copyOf(hiddenClasses);
            this.parentFirstClasses = ImmutableList.copyOf(parentFirstClasses);
            this.hiddenResources = ImmutableList.copyOf(hiddenResources);
            this.parentFirstResources = ImmutableList.copyOf(parentFirstResources);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> cachedClass = this.findLoadedClass(name);
                if (cachedClass != null) {
                    return this.resolveClass(cachedClass, resolve);
                }
                if (!this.isParentFirstClass(name)) {
                    try {
                        Class<?> clazz = this.findClass(name);
                        return this.resolveClass(clazz, resolve);
                    }
                    catch (ClassNotFoundException ignored) {
                        // empty catch block
                    }
                }
                if (!this.isHiddenClass(name)) {
                    try {
                        Class<?> clazz = this.getParent().loadClass(name);
                        return this.resolveClass(clazz, resolve);
                    }
                    catch (ClassNotFoundException ignored) {
                        // empty catch block
                    }
                }
                if (this.isParentFirstClass(name)) {
                    Class<?> clazz = this.findClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                throw new ClassNotFoundException(name);
            }
        }

        private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        private boolean isParentFirstClass(String name) {
            for (String nonOverridableClass : this.parentFirstClasses) {
                if (!name.startsWith(nonOverridableClass)) continue;
                return true;
            }
            return false;
        }

        private boolean isHiddenClass(String name) {
            for (String hiddenClass : this.hiddenClasses) {
                if (!name.startsWith(hiddenClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public URL getResource(String name) {
            URL url;
            if (!this.isParentFirstResource(name) && (url = this.findResource(name)) != null) {
                return url;
            }
            if (!this.isHiddenResource(name) && (url = this.getParent().getResource(name)) != null) {
                return url;
            }
            if (this.isParentFirstResource(name) && (url = this.findResource(name)) != null) {
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            UnmodifiableIterator myResources;
            ArrayList<UnmodifiableIterator> resources = new ArrayList<UnmodifiableIterator>();
            if (!this.isParentFirstResource(name)) {
                myResources = Iterators.forEnumeration(this.findResources(name));
                resources.add(myResources);
            }
            if (!this.isHiddenResource(name)) {
                UnmodifiableIterator parentResources = Iterators.forEnumeration(this.getParent().getResources(name));
                resources.add(parentResources);
            }
            if (this.isParentFirstResource(name)) {
                myResources = Iterators.forEnumeration(this.findResources(name));
                resources.add(myResources);
            }
            return Iterators.asEnumeration((Iterator)Iterators.concat(resources.iterator()));
        }

        private boolean isParentFirstResource(String name) {
            for (String nonOverridableResource : this.parentFirstResources) {
                if (!name.startsWith(nonOverridableResource)) continue;
                return true;
            }
            return false;
        }

        private boolean isHiddenResource(String name) {
            for (String hiddenResource : this.hiddenResources) {
                if (!name.startsWith(hiddenResource)) continue;
                return true;
            }
            return false;
        }

        private static Function<String, String> classNameToResource() {
            return new Function<String, String>(){

                public String apply(String className) {
                    return className.replace('.', '/');
                }
            };
        }
    }
}

