/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.discovery.EmbeddedDiscoveryModule;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.server.CodeCacheGcTrigger;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PrestoJvmRequirements;
import com.facebook.presto.server.ServerMainModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.event.client.HttpEventModule;
import io.airlift.event.client.JsonEventModule;
import io.airlift.floatingdecimal.FloatingDecimal;
import io.airlift.http.server.HttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.jmx.JmxModule;
import io.airlift.json.JsonModule;
import io.airlift.log.LogJmxModule;
import io.airlift.log.Logger;
import io.airlift.node.NodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import org.weakref.jmx.guice.MBeanModule;

public class PrestoServer
implements Runnable {
    public static void main(String[] args) {
        new PrestoServer().run();
    }

    @Override
    public void run() {
        PrestoJvmRequirements.verifyJvmRequirements();
        Logger log = Logger.get(PrestoServer.class);
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new NodeModule(), new DiscoveryModule(), new HttpServerModule(), new JsonModule(), new JaxrsModule(), new MBeanModule(), new JmxModule(), new JmxHttpModule(), new LogJmxModule(), new TraceTokenModule(), new JsonEventModule(), new HttpEventModule(), new EmbeddedDiscoveryModule(), new ServerMainModule()});
        modules.addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        try {
            Injector injector = app.strictConfig().initialize();
            if (!FloatingDecimal.isPatchInstalled()) {
                log.warn("FloatingDecimal patch not installed. Parallelism will be diminished when parsing/formatting doubles");
            }
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ((CatalogManager)injector.getInstance(CatalogManager.class)).loadCatalogs();
            ((Announcer)injector.getInstance(Announcer.class)).start();
            log.info("======== SERVER STARTED ========");
            CodeCacheGcTrigger.installCodeCacheGcTrigger();
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }

    protected Iterable<? extends Module> getAdditionalModules() {
        return ImmutableList.of();
    }
}

