/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.google.common.base.Preconditions;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerInfo;
import java.net.URI;
import javax.inject.Inject;

public class HttpLocationFactory
implements LocationFactory {
    private final NodeManager nodeManager;
    private final URI baseUri;

    @Inject
    public HttpLocationFactory(NodeManager nodeManager, HttpServerInfo httpServerInfo) {
        this(nodeManager, httpServerInfo.getHttpUri());
    }

    public HttpLocationFactory(NodeManager nodeManager, URI baseUri) {
        this.nodeManager = nodeManager;
        this.baseUri = baseUri;
    }

    public URI createQueryLocation(QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("/v1/query").appendPath(queryId.toString()).build();
    }

    public URI createStageLocation(StageId stageId) {
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("v1/stage").appendPath(stageId.toString()).build();
    }

    public URI createLocalTaskLocation(TaskId taskId) {
        return this.createTaskLocation(this.nodeManager.getCurrentNode(), taskId);
    }

    public URI createTaskLocation(Node node, TaskId taskId) {
        Preconditions.checkNotNull((Object)node, (Object)"node is null");
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)node.getHttpUri()).appendPath("/v1/task").appendPath(taskId.toString()).build();
    }
}

