/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.avro;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;

public class AvroColumnDecoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object[])new Type[]{DoubleType.DOUBLE, VarbinaryType.VARBINARY});
    private final Type columnType;
    private final String columnMapping;
    private final String columnName;

    public AvroColumnDecoder(DecoderColumnHandle columnHandle) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.columnType = columnHandle.getType();
            this.columnMapping = columnHandle.getMapping();
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((boolean)this.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType, (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private boolean isSupportedType(Type type) {
        if (this.isSupportedPrimitive(type)) {
            return true;
        }
        if (type.getTypeSignature().getBase().equalsIgnoreCase("array")) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return this.isSupportedPrimitive((Type)type.getTypeParameters().get(0));
        }
        if (type.getTypeSignature().getBase().equalsIgnoreCase("map")) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            Preconditions.checkArgument((boolean)(typeParameters.get(0) instanceof VarcharType), (String)"Unsupported column type '%s' for map key", typeParameters.get(0));
            return this.isSupportedPrimitive((Type)type.getTypeParameters().get(1));
        }
        return false;
    }

    private boolean isSupportedPrimitive(Type type) {
        return Varchars.isVarcharType((Type)type) || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    public FieldValueProvider decodeField(GenericRecord avroRecord) {
        Object avroColumnValue = AvroColumnDecoder.locateNode(avroRecord, this.columnMapping);
        return new ObjectValueProvider(avroColumnValue, this.columnType, this.columnName);
    }

    private static Object locateNode(GenericRecord element, String columnMapping) {
        Object value = element;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)columnMapping)) {
            if (value == null) {
                return null;
            }
            value = value.get(pathElement);
        }
        return value;
    }

    private static Slice getSlice(Object value, Type type, String columnName) {
        switch (type.getTypeSignature().getBase()) {
            case "varchar": {
                if (type instanceof VarcharType && (value instanceof CharSequence || value instanceof GenericEnumSymbol)) {
                    return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value.toString()), (Type)type);
                }
            }
            case "varbinary": {
                if (value instanceof ByteBuffer) {
                    return Slices.wrappedBuffer((ByteBuffer)((ByteBuffer)value));
                }
                if (!(value instanceof GenericFixed)) break;
                return Slices.wrappedBuffer((byte[])((GenericFixed)value).bytes());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    private static Block serializeObject(BlockBuilder builder, Object value, Type type, String columnName) {
        switch (type.getTypeSignature().getBase()) {
            case "array": {
                return AvroColumnDecoder.serializeList(builder, value, type, columnName);
            }
            case "map": {
                return AvroColumnDecoder.serializeMap(builder, value, type, columnName);
            }
        }
        AvroColumnDecoder.serializePrimitive(builder, value, type, columnName);
        return null;
    }

    private static Block serializeList(BlockBuilder blockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Objects.requireNonNull(blockBuilder, "parent blockBuilder is null").appendNull();
            return blockBuilder.build();
        }
        List list = (List)value;
        List typeParameters = type.getTypeParameters();
        Type elementType = (Type)typeParameters.get(0);
        BlockBuilder currentBlockBuilder = blockBuilder != null ? blockBuilder.beginBlockEntry() : elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            AvroColumnDecoder.serializeObject(currentBlockBuilder, element, elementType, columnName);
        }
        if (blockBuilder != null) {
            blockBuilder.closeEntry();
            return null;
        }
        return currentBlockBuilder.build();
    }

    private static void serializePrimitive(BlockBuilder blockBuilder, Object value, Type type, String columnName) {
        Objects.requireNonNull(blockBuilder, "parent blockBuilder is null");
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        switch (type.getTypeSignature().getBase()) {
            case "boolean": {
                type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
                break;
            }
            case "integer": 
            case "bigint": {
                type.writeLong(blockBuilder, ((Number)value).longValue());
                break;
            }
            case "double": {
                type.writeDouble(blockBuilder, ((Double)value).doubleValue());
                break;
            }
            case "real": {
                type.writeLong(blockBuilder, (long)Float.floatToIntBits(((Float)value).floatValue()));
                break;
            }
            case "varchar": 
            case "varbinary": {
                type.writeSlice(blockBuilder, AvroColumnDecoder.getSlice(value, type, columnName));
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
            }
        }
    }

    private static Block serializeMap(BlockBuilder blockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Objects.requireNonNull(blockBuilder, "parent blockBuilder is null").appendNull();
            return blockBuilder.build();
        }
        Map map = (Map)value;
        List typeParameters = type.getTypeParameters();
        Type keyType = (Type)typeParameters.get(0);
        Type valueType = (Type)typeParameters.get(1);
        boolean builderSynthesized = false;
        if (blockBuilder == null) {
            builderSynthesized = true;
            blockBuilder = type.createBlockBuilder(null, 1);
        }
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            keyType.writeSlice(entryBuilder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)entry.getKey().toString()), (Type)keyType));
            AvroColumnDecoder.serializeObject(entryBuilder, entry.getValue(), valueType, columnName);
        }
        blockBuilder.closeEntry();
        if (builderSynthesized) {
            return (Block)type.getObject((Block)blockBuilder, 0);
        }
        return null;
    }

    private static class ObjectValueProvider
    extends FieldValueProvider {
        private final Object value;
        private final Type columnType;
        private final String columnName;

        public ObjectValueProvider(Object value, Type columnType, String columnName) {
            this.value = value;
            this.columnType = columnType;
            this.columnName = columnName;
        }

        @Override
        public boolean isNull() {
            return this.value == null;
        }

        @Override
        public double getDouble() {
            if (this.value instanceof Double || this.value instanceof Float) {
                return ((Number)this.value).doubleValue();
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        @Override
        public boolean getBoolean() {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        @Override
        public long getLong() {
            if (this.value instanceof Long || this.value instanceof Integer) {
                return ((Number)this.value).longValue();
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        @Override
        public Slice getSlice() {
            return AvroColumnDecoder.getSlice(this.value, this.columnType, this.columnName);
        }

        @Override
        public Block getBlock() {
            return AvroColumnDecoder.serializeObject(null, this.value, this.columnType, this.columnName);
        }
    }
}

