/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.decoder.RowDecoderFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class DispatchingRowDecoderFactory {
    private final Map<String, RowDecoderFactory> factories;

    @Inject
    public DispatchingRowDecoderFactory(Map<String, RowDecoderFactory> factories) {
        this.factories = ImmutableMap.copyOf(factories);
    }

    public RowDecoder create(String dataFormat, Map<String, String> decoderParams, Set<DecoderColumnHandle> columns) {
        Preconditions.checkArgument((boolean)this.factories.containsKey(dataFormat), (String)"unknown data format '%s'", (Object)dataFormat);
        return this.factories.get(dataFormat).create(decoderParams, columns);
    }
}

