/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.csv;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.FieldValueProviders;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

public class CsvColumnDecoder {
    private final String columnName;
    private final Type columnType;
    private final int columnIndex;

    public CsvColumnDecoder(DecoderColumnHandle columnHandle) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)columnHandle.getName());
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            this.columnType = columnHandle.getType();
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            try {
                this.columnIndex = Integer.parseInt(columnHandle.getMapping());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("invalid mapping '%s' for column '%s'", columnHandle.getMapping(), this.columnName));
            }
            Preconditions.checkArgument((this.columnIndex >= 0 ? 1 : 0) != 0, (String)"invalid mapping '%s' for column '%s'", (Object)columnHandle.getMapping(), (Object)this.columnName);
            Preconditions.checkArgument((boolean)CsvColumnDecoder.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType.getDisplayName(), (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private static boolean isSupportedType(Type type) {
        if (Varchars.isVarcharType((Type)type)) {
            return true;
        }
        return ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE).contains((Object)type);
    }

    public FieldValueProvider decodeField(final String[] tokens) {
        if (this.columnIndex >= tokens.length) {
            return FieldValueProviders.nullValueProvider();
        }
        return new FieldValueProvider(){

            @Override
            public boolean isNull() {
                return tokens[CsvColumnDecoder.this.columnIndex].isEmpty();
            }

            @Override
            public boolean getBoolean() {
                try {
                    return Boolean.parseBoolean(tokens[CsvColumnDecoder.this.columnIndex].trim());
                }
                catch (NumberFormatException e) {
                    throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", tokens[CsvColumnDecoder.this.columnIndex].trim(), CsvColumnDecoder.this.columnType, CsvColumnDecoder.this.columnName));
                }
            }

            @Override
            public long getLong() {
                try {
                    return Long.parseLong(tokens[CsvColumnDecoder.this.columnIndex].trim());
                }
                catch (NumberFormatException e) {
                    throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", tokens[CsvColumnDecoder.this.columnIndex].trim(), CsvColumnDecoder.this.columnType, CsvColumnDecoder.this.columnName));
                }
            }

            @Override
            public double getDouble() {
                try {
                    return Double.parseDouble(tokens[CsvColumnDecoder.this.columnIndex].trim());
                }
                catch (NumberFormatException e) {
                    throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", tokens[CsvColumnDecoder.this.columnIndex].trim(), CsvColumnDecoder.this.columnType, CsvColumnDecoder.this.columnName));
                }
            }

            @Override
            public Slice getSlice() {
                return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)tokens[CsvColumnDecoder.this.columnIndex]), (Type)CsvColumnDecoder.this.columnType);
            }
        };
    }
}

