/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.decoder.json.JsonFieldDecoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JsonRowDecoder
implements RowDecoder {
    public static final String NAME = "json";
    private final ObjectMapper objectMapper;
    private final Map<DecoderColumnHandle, JsonFieldDecoder> fieldDecoders;

    JsonRowDecoder(ObjectMapper objectMapper, Map<DecoderColumnHandle, JsonFieldDecoder> fieldDecoders) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.fieldDecoders = ImmutableMap.copyOf(fieldDecoders);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data, Map<String, String> dataMap) {
        JsonNode tree;
        try {
            tree = this.objectMapper.readTree(data);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        HashMap<DecoderColumnHandle, FieldValueProvider> decodedRow = new HashMap<DecoderColumnHandle, FieldValueProvider>();
        for (Map.Entry<DecoderColumnHandle, JsonFieldDecoder> entry : this.fieldDecoders.entrySet()) {
            DecoderColumnHandle columnHandle = entry.getKey();
            JsonFieldDecoder decoder = entry.getValue();
            JsonNode node = JsonRowDecoder.locateNode(tree, columnHandle);
            decodedRow.put(columnHandle, decoder.decode(node));
        }
        return Optional.of(decodedRow);
    }

    private static JsonNode locateNode(JsonNode tree, DecoderColumnHandle columnHandle) {
        String mapping = columnHandle.getMapping();
        Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for %s", (Object)columnHandle.getName());
        JsonNode currentNode = tree;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)mapping)) {
            if (!currentNode.has(pathElement)) {
                return MissingNode.getInstance();
            }
            currentNode = currentNode.path(pathElement);
        }
        return currentNode;
    }
}

