/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.avro;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.decoder.avro.AvroColumnDecoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;

public class AvroRowDecoder
implements RowDecoder {
    public static final String NAME = "avro";
    private final DatumReader<GenericRecord> avroRecordReader;
    private final Map<DecoderColumnHandle, AvroColumnDecoder> columnDecoders;

    public AvroRowDecoder(DatumReader<GenericRecord> avroRecordReader, Set<DecoderColumnHandle> columns) {
        this.avroRecordReader = Objects.requireNonNull(avroRecordReader, "avroRecordReader is null");
        Objects.requireNonNull(columns, "columns is null");
        this.columnDecoders = (Map)columns.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), this::createColumnDecoder));
    }

    private AvroColumnDecoder createColumnDecoder(DecoderColumnHandle columnHandle) {
        return new AvroColumnDecoder(columnHandle);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data, Map<String, String> dataMap) {
        GenericRecord avroRecord;
        DataFileStream dataFileReader = null;
        try {
            dataFileReader = new DataFileStream((InputStream)new ByteArrayInputStream(data), this.avroRecordReader);
            if (!dataFileReader.hasNext()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "No avro record found");
            }
            avroRecord = (GenericRecord)dataFileReader.next();
            if (dataFileReader.hasNext()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected extra record found");
            }
            this.closeQuietly((DataFileStream<GenericRecord>)dataFileReader);
        }
        catch (Exception e) {
            try {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Decoding AVRO record failed.", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(dataFileReader);
                throw throwable;
            }
        }
        return Optional.of(this.columnDecoders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((AvroColumnDecoder)entry.getValue()).decodeField(avroRecord))));
    }

    private void closeQuietly(DataFileStream<GenericRecord> stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

