/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder;

import com.facebook.presto.decoder.DecoderRegistry;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.decoder.csv.CsvDecoderModule;
import com.facebook.presto.decoder.dummy.DummyDecoderModule;
import com.facebook.presto.decoder.json.JsonDecoderModule;
import com.facebook.presto.decoder.raw.RawDecoderModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;

public class DecoderModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(DecoderRegistry.class).in(Scopes.SINGLETON);
        binder.install((Module)new DummyDecoderModule());
        binder.install((Module)new CsvDecoderModule());
        binder.install((Module)new JsonDecoderModule());
        binder.install((Module)new RawDecoderModule());
    }

    public static void bindRowDecoder(Binder binder, Class<? extends RowDecoder> decoderClass) {
        Multibinder rowDecoderBinder = Multibinder.newSetBinder((Binder)binder, RowDecoder.class);
        rowDecoderBinder.addBinding().to(decoderClass).in(Scopes.SINGLETON);
    }

    public static void bindFieldDecoder(Binder binder, Class<? extends FieldDecoder<?>> decoderClass) {
        Multibinder fieldDecoderBinder = Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<FieldDecoder<?>>(){});
        fieldDecoderBinder.addBinding().to(decoderClass).in(Scopes.SINGLETON);
    }
}

