/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class JsonRowDecoder
implements RowDecoder {
    public static final String NAME = "json";
    private final ObjectMapper objectMapper;

    @Inject
    JsonRowDecoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean decodeRow(byte[] data, Map<String, String> dataMap, Set<FieldValueProvider> fieldValueProviders, List<DecoderColumnHandle> columnHandles, Map<DecoderColumnHandle, FieldDecoder<?>> fieldDecoders) {
        JsonNode tree;
        try {
            tree = this.objectMapper.readTree(data);
        }
        catch (Exception e) {
            return true;
        }
        for (DecoderColumnHandle columnHandle : columnHandles) {
            FieldDecoder<?> decoder;
            if (columnHandle.isInternal() || (decoder = fieldDecoders.get(columnHandle)) == null) continue;
            JsonNode node = JsonRowDecoder.locateNode(tree, columnHandle);
            fieldValueProviders.add(decoder.decode(node, columnHandle));
        }
        return false;
    }

    private static JsonNode locateNode(JsonNode tree, DecoderColumnHandle columnHandle) {
        String mapping = columnHandle.getMapping();
        Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for %s", (Object[])new Object[]{columnHandle.getName()});
        JsonNode currentNode = tree;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)mapping)) {
            if (!currentNode.has(pathElement)) {
                return MissingNode.getInstance();
            }
            currentNode = currentNode.path(pathElement);
        }
        return currentNode;
    }
}

