/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.json.JsonFieldDecoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RFC2822JsonFieldDecoder
extends JsonFieldDecoder {
    @VisibleForTesting
    static final String NAME = "rfc2822";
    @VisibleForTesting
    static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.ENGLISH).withZoneUTC();

    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Long.TYPE, Slice.class);
    }

    @Override
    public String getFieldDecoderName() {
        return NAME;
    }

    @Override
    public FieldValueProvider decode(JsonNode value, DecoderColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Objects.requireNonNull(value, "value is null");
        return new RFC2822JsonValueProvider(value, columnHandle);
    }

    public static class RFC2822JsonValueProvider
    extends JsonFieldDecoder.DateTimeJsonValueProvider {
        public RFC2822JsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        protected long getMillis() {
            if (this.isNull()) {
                return 0L;
            }
            if (this.value.canConvertToLong()) {
                return this.value.asLong();
            }
            String textValue = this.value.isValueNode() ? this.value.asText() : this.value.toString();
            return FORMATTER.parseMillis(textValue);
        }
    }
}

