/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.json.JsonFieldDecoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CustomDateTimeJsonFieldDecoder
extends JsonFieldDecoder {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Long.TYPE, Slice.class);
    }

    @Override
    public String getFieldDecoderName() {
        return "custom-date-time";
    }

    @Override
    public FieldValueProvider decode(JsonNode value, DecoderColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Objects.requireNonNull(value, "value is null");
        return new CustomDateTimeJsonValueProvider(value, columnHandle);
    }

    public static class CustomDateTimeJsonValueProvider
    extends JsonFieldDecoder.DateTimeJsonValueProvider {
        public CustomDateTimeJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        protected long getMillis() {
            if (this.isNull()) {
                return 0L;
            }
            if (this.value.canConvertToLong()) {
                return this.value.asLong();
            }
            Objects.requireNonNull(this.columnHandle.getFormatHint(), "formatHint is null");
            String textValue = this.value.isValueNode() ? this.value.asText() : this.value.toString();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.columnHandle.getFormatHint()).withLocale(Locale.ENGLISH).withZoneUTC();
            return formatter.parseMillis(textValue);
        }
    }
}

