/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.postgresql;

import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import javax.inject.Inject;
import org.postgresql.Driver;

public class PostgreSqlClient
extends BaseJdbcClient {
    @Inject
    public PostgreSqlClient(JdbcConnectorId connectorId, BaseJdbcConfig config) throws SQLException {
        super(connectorId, config, "\"", (java.sql.Driver)new Driver());
    }

    public void commitCreateTable(JdbcOutputTableHandle handle, Collection<Slice> fragments) {
        StringBuilder sql = new StringBuilder().append("ALTER TABLE ").append(this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName())).append(" RENAME TO ").append(this.quoted(handle.getTableName()));
        try (Connection connection = this.getConnection(handle);){
            this.execute(connection, sql.toString());
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Statement getStatement(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.setFetchSize(1000);
        return statement;
    }
}

