/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.util;

import java.util.Objects;

public final class Closables {
    private Closables() {
    }

    public static <T extends Throwable> T closeAllSuppress(T rootCause, AutoCloseable ... closeables) {
        Objects.requireNonNull(rootCause, "rootCause is null");
        Objects.requireNonNull(closeables, "closeables is null");
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable e) {
                if (rootCause == e) continue;
                rootCause.addSuppressed(e);
            }
        }
        return rootCause;
    }
}

