/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public class WithQuery
extends Node {
    private final String name;
    private final Query query;
    private final List<String> columnNames;

    public WithQuery(String name, Query query, List<String> columnNames) {
        this.name = QualifiedName.of((String)Preconditions.checkNotNull((Object)name, (Object)"name is null"), new String[0]).getParts().get(0);
        this.query = (Query)Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.columnNames = columnNames;
    }

    public String getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithQuery(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.columnNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WithQuery o = (WithQuery)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.columnNames, o.columnNames);
    }
}

