/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class Row
extends Node {
    private final List<Expression> items;

    public Row(List<Expression> items) {
        Preconditions.checkNotNull(items, (Object)"items is null");
        this.items = ImmutableList.copyOf(items);
    }

    public List<Expression> getItems() {
        return this.items;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRow(this, context);
    }

    @Override
    public String toString() {
        return "(" + Joiner.on((String)", ").join(this.items) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return Objects.equals(this.items, other.items);
    }
}

