/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public final class QueryUtil {
    private QueryUtil() {
    }

    public static Expression nameReference(String name) {
        return new QualifiedNameReference(QualifiedName.of(name, new String[0]));
    }

    public static SelectItem unaliasedName(String name) {
        return new SingleColumn(QueryUtil.nameReference(name));
    }

    public static SelectItem aliasedName(String name, String alias) {
        return new SingleColumn(QueryUtil.nameReference(name), alias);
    }

    public static Select selectList(Expression ... expressions) {
        ImmutableList.Builder items = ImmutableList.builder();
        for (Expression expression : expressions) {
            items.add((Object)new SingleColumn(expression));
        }
        return new Select(false, (List<SelectItem>)items.build());
    }

    public static Select selectList(SelectItem ... items) {
        return new Select(false, (List<SelectItem>)ImmutableList.copyOf((Object[])items));
    }

    public static Select selectAll(List<SelectItem> items) {
        return new Select(false, items);
    }

    public static Optional<Relation> table(QualifiedName name) {
        return Optional.of(new Table(name));
    }

    public static Optional<Relation> subquery(Query query) {
        return Optional.of(new TableSubquery(query));
    }

    public static SortItem ascending(String name) {
        return new SortItem(QueryUtil.nameReference(name), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED);
    }

    public static Expression logicalAnd(Expression left, Expression right) {
        return new LogicalBinaryExpression(LogicalBinaryExpression.Type.AND, left, right);
    }

    public static Expression equal(Expression left, Expression right) {
        return new ComparisonExpression(ComparisonExpression.Type.EQUAL, left, right);
    }

    public static Expression caseWhen(Expression operand, Expression result) {
        return new SearchedCaseExpression((List<WhenClause>)ImmutableList.of((Object)new WhenClause(operand, result)), null);
    }

    public static Expression functionCall(String name, Expression ... arguments) {
        return new FunctionCall(new QualifiedName(name), (List<Expression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static Values values(Row ... row) {
        return new Values((List<Row>)ImmutableList.copyOf((Object[])row));
    }

    public static Row row(Expression ... values) {
        return new Row((List<Expression>)ImmutableList.copyOf((Object[])values));
    }

    public static Relation aliased(Relation relation, String alias, List<String> columnAliases) {
        return new AliasedRelation(relation, alias, columnAliases);
    }
}

