/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class RenameTable
extends Statement {
    private final QualifiedName source;
    private final QualifiedName target;

    public RenameTable(QualifiedName source, QualifiedName target) {
        this.source = (QualifiedName)Preconditions.checkNotNull((Object)source, (Object)"source name is null");
        this.target = (QualifiedName)Preconditions.checkNotNull((Object)target, (Object)"target name is null");
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public QualifiedName getTarget() {
        return this.target;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameTable(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.target});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RenameTable o = (RenameTable)obj;
        return Objects.equal((Object)this.source, (Object)o.source) && Objects.equal((Object)this.target, (Object)o.target);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).toString();
    }
}

