/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SimpleCaseExpression
extends Expression {
    private final Expression operand;
    private final List<WhenClause> whenClauses;
    private final Expression defaultValue;

    public SimpleCaseExpression(Expression operand, List<WhenClause> whenClauses, Expression defaultValue) {
        Preconditions.checkNotNull((Object)operand, (Object)"operand is null");
        Preconditions.checkNotNull(whenClauses, (Object)"whenClauses is null");
        this.operand = operand;
        this.whenClauses = ImmutableList.copyOf(whenClauses);
        this.defaultValue = defaultValue;
    }

    public Expression getOperand() {
        return this.operand;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleCaseExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCaseExpression that = (SimpleCaseExpression)o;
        if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) {
            return false;
        }
        if (!this.operand.equals(that.operand)) {
            return false;
        }
        return this.whenClauses.equals(that.whenClauses);
    }

    @Override
    public int hashCode() {
        int result = this.operand.hashCode();
        result = 31 * result + this.whenClauses.hashCode();
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        return result;
    }
}

