/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class CreateMaterializedView
extends Statement {
    private final QualifiedName name;
    private final Optional<String> refresh;
    private final Query tableDefinition;

    public CreateMaterializedView(QualifiedName name, Optional<String> refresh, Query tableDefinition) {
        this.name = (QualifiedName)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.refresh = (Optional)Preconditions.checkNotNull(refresh, (Object)"refresh is null");
        this.tableDefinition = (Query)Preconditions.checkNotNull((Object)tableDefinition, (Object)"tableDefinition is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<String> getRefresh() {
        return this.refresh;
    }

    public Query getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateMaterializedView(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.refresh, this.tableDefinition});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMaterializedView o = (CreateMaterializedView)obj;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal(this.refresh, o.refresh) && Objects.equal((Object)this.tableDefinition, (Object)o.tableDefinition);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("refresh", this.refresh).add("tableDefinition", (Object)this.tableDefinition).toString();
    }
}

