/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.MergeCase;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MergeInsert
extends MergeCase {
    private final List<Identifier> columns;
    private final List<Expression> values;

    public MergeInsert(List<Identifier> columns, List<Expression> values) {
        this(Optional.empty(), columns, values);
    }

    public MergeInsert(NodeLocation location, List<Identifier> columns, List<Expression> values) {
        this(Optional.of(location), columns, values);
    }

    public MergeInsert(Optional<NodeLocation> location, List<Identifier> columns, List<Expression> values) {
        super(location);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
    }

    public List<Identifier> getColumns() {
        return this.columns;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMergeInsert(this, context);
    }

    @Override
    public List<Identifier> getSetColumns() {
        return this.columns;
    }

    @Override
    public List<Expression> getSetExpressions() {
        return this.values;
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.columns);
        builder.addAll(this.values);
        return builder.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns, this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MergeInsert o = (MergeInsert)obj;
        return Objects.equals(this.columns, o.columns) && Objects.equals(this.values, o.values);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).add("values", this.values).omitNullValues().toString();
    }
}

