/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropFunction
extends Statement {
    private final QualifiedName functionName;
    private final Optional<List<String>> parameterTypes;
    private final boolean temporary;
    private final boolean exists;

    public DropFunction(QualifiedName functionName, Optional<List<String>> parameterTypes, boolean temporary, boolean exists) {
        this(Optional.empty(), functionName, parameterTypes, temporary, exists);
    }

    public DropFunction(NodeLocation location, QualifiedName functionName, Optional<List<String>> parameterTypes, boolean temporary, boolean exists) {
        this(Optional.of(location), functionName, parameterTypes, temporary, exists);
    }

    private DropFunction(Optional<NodeLocation> location, QualifiedName functionName, Optional<List<String>> parameterTypes, boolean temporary, boolean exists) {
        super(location);
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes is null").map(ImmutableList::copyOf);
        this.temporary = temporary;
        this.exists = exists;
    }

    public QualifiedName getFunctionName() {
        return this.functionName;
    }

    public Optional<List<String>> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("DROP FUNCTION", this.functionName.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionName, this.parameterTypes, this.temporary, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropFunction o = (DropFunction)obj;
        return Objects.equals(this.functionName, o.functionName) && Objects.equals(this.temporary, o.temporary) && Objects.equals(this.parameterTypes, o.parameterTypes) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("parameterTypes", this.parameterTypes).add("temporary", this.temporary).add("exists", this.exists).toString();
    }
}

