/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropConstraint
extends Statement {
    private final QualifiedName tableName;
    private final String constraintName;
    private final boolean tableExists;
    private final boolean constraintExists;

    public DropConstraint(QualifiedName tableName, String constraintName, boolean tableExists, boolean constraintExists) {
        this(Optional.empty(), tableName, constraintName, tableExists, constraintExists);
    }

    public DropConstraint(NodeLocation location, QualifiedName tableName, String constraintName, boolean tableExists, boolean constraintExists) {
        this(Optional.of(location), tableName, constraintName, tableExists, constraintExists);
    }

    private DropConstraint(Optional<NodeLocation> location, QualifiedName tableName, String constraintName, boolean tableExists, boolean constraintExists) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "table is null");
        this.constraintName = Objects.requireNonNull(constraintName, "constraint is null");
        this.tableExists = tableExists;
        this.constraintExists = constraintExists;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isConstraintExists() {
        return this.constraintExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropConstraint(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("DROP CONSTRAINT", this.tableName.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropConstraint that = (DropConstraint)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.constraintName, that.constraintName) && Objects.equals(this.tableExists, that.tableExists) && Objects.equals(this.constraintExists, this.constraintExists);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.tableExists, this.constraintName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.tableName).add("constraint", (Object)this.constraintName).add("tableExists", this.tableExists).add("constraintExists", this.constraintExists).toString();
    }
}

