/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DescriptorField
extends Node {
    private final Identifier name;
    private final Optional<String> type;

    public DescriptorField(NodeLocation location, Identifier name, Optional<String> type) {
        super(Optional.of(location));
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public Optional<String> getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDescriptorField(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorField field = (DescriptorField)o;
        return Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Override
    public String toString() {
        return this.type.map(dataType -> this.name + " " + dataType).orElse(this.name.toString());
    }
}

