/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateTableAsSelect
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean notExists;
    private final List<Property> properties;
    private final boolean withData;
    private final Optional<List<Identifier>> columnAliases;
    private final Optional<String> comment;

    public CreateTableAsSelect(QualifiedName name, Query query, boolean notExists, List<Property> properties, boolean withData, Optional<List<Identifier>> columnAliases, Optional<String> comment) {
        this(Optional.empty(), name, query, notExists, properties, withData, columnAliases, comment);
    }

    public CreateTableAsSelect(NodeLocation location, QualifiedName name, Query query, boolean notExists, List<Property> properties, boolean withData, Optional<List<Identifier>> columnAliases, Optional<String> comment) {
        this(Optional.of(location), name, query, notExists, properties, withData, columnAliases, comment);
    }

    private CreateTableAsSelect(Optional<NodeLocation> location, QualifiedName name, Query query, boolean notExists, List<Property> properties, boolean withData, Optional<List<Identifier>> columnAliases, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.notExists = notExists;
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.withData = withData;
        this.columnAliases = columnAliases;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public boolean isWithData() {
        return this.withData;
    }

    public Optional<List<Identifier>> getColumnAliases() {
        return this.columnAliases;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTableAsSelect(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.query).addAll(this.properties).build();
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("CREATE TABLE", this.name.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.properties, this.withData, this.columnAliases, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTableAsSelect o = (CreateTableAsSelect)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties) && Objects.equals(this.withData, o.withData) && Objects.equals(this.columnAliases, o.columnAliases) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("notExists", this.notExists).add("properties", this.properties).add("withData", this.withData).add("columnAliases", this.columnAliases).add("comment", this.comment).toString();
    }
}

