/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AlterRoutineCharacteristics;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AlterFunction
extends Statement {
    private final QualifiedName functionName;
    private final Optional<List<String>> parameterTypes;
    private final AlterRoutineCharacteristics characteristics;

    public AlterFunction(QualifiedName functionName, Optional<List<String>> parameterTypes, AlterRoutineCharacteristics characteristics) {
        this(Optional.empty(), functionName, parameterTypes, characteristics);
    }

    public AlterFunction(NodeLocation location, QualifiedName functionName, Optional<List<String>> parameterTypes, AlterRoutineCharacteristics characteristics) {
        this(Optional.of(location), functionName, parameterTypes, characteristics);
    }

    private AlterFunction(Optional<NodeLocation> location, QualifiedName functionName, Optional<List<String>> parameterTypes, AlterRoutineCharacteristics characteristics) {
        super(location);
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes is null");
        this.characteristics = Objects.requireNonNull(characteristics, "characteristics is null");
    }

    public QualifiedName getFunctionName() {
        return this.functionName;
    }

    public Optional<List<String>> getParameterTypes() {
        return this.parameterTypes;
    }

    public AlterRoutineCharacteristics getCharacteristics() {
        return this.characteristics;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterFunction(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionName, this.parameterTypes, this.characteristics);
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("ALTER FUNCTION", this.functionName.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AlterFunction o = (AlterFunction)obj;
        return Objects.equals(this.functionName, o.functionName) && Objects.equals(this.parameterTypes, o.parameterTypes) && Objects.equals(this.characteristics, o.characteristics);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("parameterTypes", this.parameterTypes).add("characteristics", (Object)this.characteristics).toString();
    }
}

