/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.TableFunctionArgument;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class TableFunctionInvocation
extends Relation {
    private final QualifiedName name;
    private final List<TableFunctionArgument> arguments;
    private final List<List<QualifiedName>> copartitioning;

    public TableFunctionInvocation(NodeLocation location, QualifiedName name, List<TableFunctionArgument> arguments, List<List<QualifiedName>> copartitioning) {
        super(Optional.of(location));
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.copartitioning = Objects.requireNonNull(copartitioning, "copartitioning is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<TableFunctionArgument> getArguments() {
        return this.arguments;
    }

    public List<List<QualifiedName>> getCopartitioning() {
        return this.copartitioning;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunctionInvocation(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFunctionInvocation that = (TableFunctionInvocation)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.copartitioning, that.copartitioning);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.arguments, this.copartitioning);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append("(");
        builder.append(this.arguments.stream().map(TableFunctionArgument::toString).collect(Collectors.joining(", ")));
        if (!this.copartitioning.isEmpty()) {
            builder.append(" COPARTITION");
            builder.append(this.copartitioning.stream().map(list -> list.stream().map(QualifiedName::toString).collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(", ")));
        }
        builder.append(")");
        return builder.toString();
    }
}

