/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class RoutineCharacteristics {
    private final Language language;
    private final Determinism determinism;
    private final NullCallClause nullCallClause;

    public RoutineCharacteristics(Optional<Language> language, Optional<Determinism> determinism, Optional<NullCallClause> nullCallClause) {
        this(language.orElse(Language.SQL), determinism.orElse(Determinism.NOT_DETERMINISTIC), nullCallClause.orElse(NullCallClause.CALLED_ON_NULL_INPUT));
    }

    public RoutineCharacteristics(Language language, Determinism determinism, NullCallClause nullCallClause) {
        this.language = Objects.requireNonNull(language, "language is null");
        this.determinism = Objects.requireNonNull(determinism, "determinism is null");
        this.nullCallClause = Objects.requireNonNull(nullCallClause, "nullCallClause is null");
    }

    public Language getLanguage() {
        return this.language;
    }

    public Determinism getDeterminism() {
        return this.determinism;
    }

    public NullCallClause getNullCallClause() {
        return this.nullCallClause;
    }

    public boolean isDeterministic() {
        return this.determinism == Determinism.DETERMINISTIC;
    }

    public boolean isCalledOnNullInput() {
        return this.nullCallClause == NullCallClause.CALLED_ON_NULL_INPUT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutineCharacteristics that = (RoutineCharacteristics)o;
        return this.language == that.language && this.determinism == that.determinism && this.nullCallClause == that.nullCallClause;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.determinism, this.nullCallClause});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("language", (Object)this.language).add("determinism", (Object)this.determinism).add("nullCallClause", (Object)this.nullCallClause).toString();
    }

    public static class Language {
        public static final Language SQL = new Language("SQL");
        private final String language;

        public Language(String language) {
            this.language = Objects.requireNonNull(language.toUpperCase());
        }

        public String getLanguage() {
            return this.language;
        }

        public int hashCode() {
            return Objects.hash(this.language);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Language that = (Language)o;
            return Objects.equals(this.language, that.language);
        }

        public String toString() {
            return this.language;
        }
    }

    public static enum Determinism {
        DETERMINISTIC,
        NOT_DETERMINISTIC;

    }

    public static enum NullCallClause {
        RETURNS_NULL_ON_NULL_INPUT,
        CALLED_ON_NULL_INPUT;

    }
}

