/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowSchemas
extends Statement {
    private final Optional<Identifier> catalog;
    private final Optional<String> likePattern;
    private final Optional<String> escape;

    public ShowSchemas(Optional<Identifier> catalog, Optional<String> likePattern, Optional<String> escape) {
        this(Optional.empty(), catalog, likePattern, escape);
    }

    public ShowSchemas(NodeLocation location, Optional<Identifier> catalog, Optional<String> likePattern, Optional<String> escape) {
        this(Optional.of(location), catalog, likePattern, escape);
    }

    private ShowSchemas(Optional<NodeLocation> location, Optional<Identifier> catalog, Optional<String> likePattern, Optional<String> escape) {
        super(location);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.likePattern = Objects.requireNonNull(likePattern, "likePattern is null");
        this.escape = Objects.requireNonNull(escape, "escape is null");
    }

    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    public Optional<String> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowSchemas(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.likePattern, this.escape);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowSchemas o = (ShowSchemas)obj;
        return Objects.equals(this.catalog, o.catalog) && Objects.equals(this.likePattern, o.likePattern) && Objects.equals(this.escape, o.escape);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalog", this.catalog).add("likePattern", this.likePattern).add("escape", this.escape).toString();
    }
}

