/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Offset;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QuerySpecification
extends QueryBody {
    private final Select select;
    private final Optional<Relation> from;
    private final Optional<Expression> where;
    private final Optional<GroupBy> groupBy;
    private final Optional<Expression> having;
    private final Optional<OrderBy> orderBy;
    private final Optional<Offset> offset;
    private final Optional<String> limit;

    public QuerySpecification(Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<String> limit) {
        this(Optional.empty(), select, from, where, groupBy, having, orderBy, offset, limit);
    }

    public QuerySpecification(NodeLocation location, Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<String> limit) {
        this(Optional.of(location), select, from, where, groupBy, having, orderBy, offset, limit);
    }

    private QuerySpecification(Optional<NodeLocation> location, Select select, Optional<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<String> limit) {
        super(location);
        Objects.requireNonNull(select, "select is null");
        Objects.requireNonNull(from, "from is null");
        Objects.requireNonNull(where, "where is null");
        Objects.requireNonNull(groupBy, "groupBy is null");
        Objects.requireNonNull(having, "having is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(offset, "offset is null");
        Objects.requireNonNull(limit, "limit is null");
        this.select = select;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    public Select getSelect() {
        return this.select;
    }

    public Optional<Relation> getFrom() {
        return this.from;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expression> getHaving() {
        return this.having;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Offset> getOffset() {
        return this.offset;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuerySpecification(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.select);
        this.from.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.groupBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.having.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.offset.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("select", (Object)this.select).add("from", this.from).add("where", this.where.orElse(null)).add("groupBy", this.groupBy).add("having", this.having.orElse(null)).add("orderBy", this.orderBy).add("offset", this.offset.orElse(null)).add("limit", this.limit.orElse(null)).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpecification o = (QuerySpecification)obj;
        return Objects.equals(this.select, o.select) && Objects.equals(this.from, o.from) && Objects.equals(this.where, o.where) && Objects.equals(this.groupBy, o.groupBy) && Objects.equals(this.having, o.having) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.offset, o.offset) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.select, this.from, this.where, this.groupBy, this.having, this.orderBy, this.offset, this.limit);
    }
}

