/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.RoutineBody;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Return
extends RoutineBody {
    private final Expression expression;

    public Return(Expression expression) {
        this(Optional.empty(), expression);
    }

    public Return(NodeLocation location, Expression expression) {
        this(Optional.of(location), expression);
    }

    private Return(Optional<NodeLocation> location, Expression expression) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "Expression is null");
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitReturn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Return o = (Return)obj;
        return Objects.equals(this.expression, o.expression);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).toString();
    }
}

