/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TransactionMode;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import java.util.Map;
import java.util.Set;

public abstract class DefaultTraversalVisitor<R, C>
extends AstVisitor<R, C> {
    @Override
    protected R visitExtract(Extract node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitCast(Cast node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected R visitCoalesceExpression(CoalesceExpression node, C context) {
        for (Expression operand : node.getOperands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected R visitAtTimeZone(AtTimeZone node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getTimeZone(), context);
        return null;
    }

    @Override
    protected R visitArrayConstructor(ArrayConstructor node, C context) {
        for (Expression expression : node.getValues()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    protected R visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitQuery(Query node, C context) {
        if (node.getWith().isPresent()) {
            this.process(node.getWith().get(), context);
        }
        this.process(node.getQueryBody(), context);
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        return null;
    }

    @Override
    protected R visitWith(With node, C context) {
        for (WithQuery query : node.getQueries()) {
            this.process(query, context);
        }
        return null;
    }

    @Override
    protected R visitWithQuery(WithQuery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process(item, context);
        }
        return null;
    }

    @Override
    protected R visitSingleColumn(SingleColumn node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected R visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    protected R visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected R visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        if (node.getWindow().isPresent()) {
            this.process(node.getWindow().get(), context);
        }
        if (node.getFilter().isPresent()) {
            this.process(node.getFilter().get(), context);
        }
        return null;
    }

    @Override
    protected R visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    public R visitWindow(Window node, C context) {
        for (Expression expression : node.getPartitionBy()) {
            this.process(expression, context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getFrame().isPresent()) {
            this.process(node.getFrame().get(), context);
        }
        return null;
    }

    @Override
    public R visitWindowFrame(WindowFrame node, C context) {
        this.process(node.getStart(), context);
        if (node.getEnd().isPresent()) {
            this.process(node.getEnd().get(), context);
        }
        return null;
    }

    @Override
    public R visitFrameBound(FrameBound node, C context) {
        if (node.getValue().isPresent()) {
            this.process(node.getValue().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        return null;
    }

    @Override
    protected R visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected R visitIfExpression(IfExpression node, C context) {
        this.process(node.getCondition(), context);
        this.process(node.getTrueValue(), context);
        if (node.getFalseValue().isPresent()) {
            this.process(node.getFalseValue().get(), context);
        }
        return null;
    }

    @Override
    protected R visitTryExpression(TryExpression node, C context) {
        this.process(node.getInnerExpression(), context);
        return null;
    }

    @Override
    protected R visitBindExpression(BindExpression node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getFunction(), context);
        return null;
    }

    @Override
    protected R visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitNotExpression(NotExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        if (node.getEscape() != null) {
            this.process(node.getEscape(), context);
        }
        return null;
    }

    @Override
    protected R visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitIsNullPredicate(IsNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitSubqueryExpression(SubqueryExpression node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitOrderBy(OrderBy node, C context) {
        for (SortItem sortItem : node.getSortItems()) {
            this.process(sortItem, context);
        }
        return null;
    }

    @Override
    protected R visitSortItem(SortItem node, C context) {
        return this.process(node.getSortKey(), context);
    }

    @Override
    protected R visitQuerySpecification(QuerySpecification node, C context) {
        this.process(node.getSelect(), context);
        if (node.getFrom().isPresent()) {
            this.process(node.getFrom().get(), context);
        }
        if (node.getWhere().isPresent()) {
            this.process(node.getWhere().get(), context);
        }
        if (node.getGroupBy().isPresent()) {
            this.process(node.getGroupBy().get(), context);
        }
        if (node.getHaving().isPresent()) {
            this.process(node.getHaving().get(), context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSetOperation(SetOperation node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process(relation, context);
        }
        return null;
    }

    @Override
    protected R visitValues(Values node, C context) {
        for (Expression row : node.getRows()) {
            this.process(row, context);
        }
        return null;
    }

    @Override
    protected R visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitTableSubquery(TableSubquery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitAliasedRelation(AliasedRelation node, C context) {
        return this.process(node.getRelation(), context);
    }

    @Override
    protected R visitSampledRelation(SampledRelation node, C context) {
        this.process(node.getRelation(), context);
        this.process(node.getSamplePercentage(), context);
        return null;
    }

    @Override
    protected R visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        node.getCriteria().filter(criteria -> criteria instanceof JoinOn).map(criteria -> this.process(((JoinOn)criteria).getExpression(), context));
        return null;
    }

    @Override
    protected R visitUnnest(Unnest node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitGroupBy(GroupBy node, C context) {
        for (GroupingElement groupingElement : node.getGroupingElements()) {
            this.process(groupingElement, context);
        }
        return null;
    }

    @Override
    protected R visitGroupingElement(GroupingElement node, C context) {
        for (Set<Expression> expressions : node.enumerateGroupingSets()) {
            for (Expression expression : expressions) {
                this.process(expression, context);
            }
        }
        return null;
    }

    @Override
    protected R visitInsert(Insert node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitDelete(Delete node, C context) {
        this.process(node.getTable(), context);
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected R visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        this.process(node.getQuery(), context);
        node.getProperties().values().forEach(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected R visitCreateView(CreateView node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitSetSession(SetSession node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected R visitAddColumn(AddColumn node, C context) {
        this.process(node.getColumn(), context);
        return null;
    }

    @Override
    protected R visitCreateTable(CreateTable node, C context) {
        for (TableElement tableElement : node.getElements()) {
            this.process(tableElement, context);
        }
        for (Map.Entry entry : node.getProperties().entrySet()) {
            this.process((Node)entry.getValue(), context);
        }
        return null;
    }

    @Override
    protected R visitShowPartitions(ShowPartitions node, C context) {
        if (node.getWhere().isPresent()) {
            this.process(node.getWhere().get(), context);
        }
        for (SortItem sortItem : node.getOrderBy()) {
            this.process(sortItem, context);
        }
        return null;
    }

    @Override
    protected R visitStartTransaction(StartTransaction node, C context) {
        for (TransactionMode transactionMode : node.getTransactionModes()) {
            this.process(transactionMode, context);
        }
        return null;
    }

    @Override
    protected R visitExplain(Explain node, C context) {
        this.process(node.getStatement(), context);
        for (ExplainOption option : node.getOptions()) {
            this.process(option, context);
        }
        return null;
    }

    @Override
    protected R visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected R visitExists(ExistsPredicate node, C context) {
        this.process(node.getSubquery(), context);
        return null;
    }
}

