/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.util;

import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class AstUtils {
    public static boolean nodeContains(Node node, final Node subNode) {
        return new DefaultTraversalVisitor<Boolean, AtomicBoolean>(){

            @Override
            public Boolean process(Node node, AtomicBoolean findResultHolder) {
                if (!findResultHolder.get()) {
                    if (node == subNode) {
                        findResultHolder.set(true);
                    } else {
                        super.process(node, findResultHolder);
                    }
                }
                return findResultHolder.get();
            }
        }.process(node, new AtomicBoolean(false));
    }

    public static Stream<Node> preOrder(Node node) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new PreOrderIterator(node), 0), false);
    }

    private AstUtils() {
    }

    private static final class PreOrderIterator
    implements Iterator<Node> {
        private final Deque<Node> remaining = new ArrayDeque<Node>();

        public PreOrderIterator(Node node) {
            this.remaining.push(node);
        }

        @Override
        public boolean hasNext() {
            return this.remaining.size() > 0;
        }

        @Override
        public Node next() {
            Node node = this.remaining.pop();
            node.getChildren().forEach(this.remaining::push);
            return node;
        }
    }
}

