/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TryExpression
extends Expression {
    private final Expression innerExpression;

    public TryExpression(Expression innerExpression) {
        this(Optional.empty(), innerExpression);
    }

    public TryExpression(NodeLocation location, Expression innerExpression) {
        this(Optional.of(location), innerExpression);
    }

    private TryExpression(Optional<NodeLocation> location, Expression innerExpression) {
        super(location);
        this.innerExpression = Objects.requireNonNull(innerExpression, "innerExpression is null");
    }

    public Expression getInnerExpression() {
        return this.innerExpression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTryExpression(this, context);
    }

    @Override
    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.innerExpression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryExpression o = (TryExpression)obj;
        return Objects.equals(this.innerExpression, o.innerExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.innerExpression);
    }
}

