/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.TableElement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ColumnDefinition
extends TableElement {
    private final String name;
    private final String type;
    private final Optional<String> comment;

    public ColumnDefinition(String name, String type, Optional<String> comment) {
        this(Optional.empty(), name, type, comment);
    }

    public ColumnDefinition(NodeLocation location, String name, String type, Optional<String> comment) {
        this(Optional.of(location), name, type, comment);
    }

    private ColumnDefinition(Optional<NodeLocation> location, String name, String type, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumnDefinition(this, context);
    }

    @Override
    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDefinition o = (ColumnDefinition)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.type, o.type) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type, this.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("comment", this.comment).toString();
    }
}

