/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CoalesceExpression
extends Expression {
    private final List<Expression> operands;

    public CoalesceExpression(Expression ... operands) {
        this(Optional.empty(), (List<Expression>)ImmutableList.copyOf((Object[])operands));
    }

    public CoalesceExpression(List<Expression> operands) {
        this(Optional.empty(), operands);
    }

    public CoalesceExpression(NodeLocation location, List<Expression> operands) {
        this(Optional.of(location), operands);
    }

    private CoalesceExpression(Optional<NodeLocation> location, List<Expression> operands) {
        super(location);
        Objects.requireNonNull(operands, "operands is null");
        Preconditions.checkArgument((!operands.isEmpty() ? 1 : 0) != 0, (Object)"operands is empty");
        this.operands = ImmutableList.copyOf(operands);
    }

    public List<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCoalesceExpression(this, context);
    }

    @Override
    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.operands).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoalesceExpression that = (CoalesceExpression)o;
        return Objects.equals(this.operands, that.operands);
    }

    @Override
    public int hashCode() {
        return this.operands.hashCode();
    }
}

