/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.DataDefinitionStatement;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class DropView
extends DataDefinitionStatement {
    private final QualifiedName name;
    private final boolean exists;

    public DropView(QualifiedName name, boolean exists) {
        this(Optional.empty(), name, exists);
    }

    public DropView(NodeLocation location, QualifiedName name, boolean exists) {
        this(Optional.of(location), name, exists);
    }

    private DropView(Optional<NodeLocation> location, QualifiedName name, boolean exists) {
        super(location);
        this.name = name;
        this.exists = exists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropView(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropView o = (DropView)obj;
        return Objects.equals(this.name, o.name) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("exists", this.exists).toString();
    }
}

