/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class ComparisonExpression
extends Expression {
    private final ComparisonExpressionType type;
    private final Expression left;
    private final Expression right;

    public ComparisonExpression(ComparisonExpressionType type, Expression left, Expression right) {
        this(Optional.empty(), type, left, right);
    }

    public ComparisonExpression(NodeLocation location, ComparisonExpressionType type, Expression left, Expression right) {
        this(Optional.of(location), type, left, right);
    }

    private ComparisonExpression(Optional<NodeLocation> location, ComparisonExpressionType type, Expression left, Expression right) {
        super(location);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.type = type;
        this.left = left;
        this.right = right;
    }

    public ComparisonExpressionType getType() {
        return this.type;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitComparisonExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpression that = (ComparisonExpression)o;
        return this.type == that.type && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right});
    }
}

