/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.sql.parser.CaseInsensitiveStream;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.type.TypeCalculationBaseVisitor;
import com.facebook.presto.type.TypeCalculationLexer;
import com.facebook.presto.type.TypeCalculationParser;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public final class TypeCalculation {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine);
        }
    };

    private TypeCalculation() {
    }

    public static Long calculateLiteralValue(String calculation, Map<String, Long> inputs) {
        try {
            ParserRuleContext tree = TypeCalculation.parseTypeCalculation(calculation);
            return (Long)new CalculateTypeVisitor(inputs).visit((ParseTree)tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("Type calculation is too large (stack overflow while parsing)");
        }
    }

    private static ParserRuleContext parseTypeCalculation(String calculation) {
        TypeCalculationParser.TypeCalculationContext tree;
        TypeCalculationLexer lexer = new TypeCalculationLexer(new CaseInsensitiveStream((CharStream)new ANTLRInputStream(calculation)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        TypeCalculationParser parser = new TypeCalculationParser((TokenStream)tokenStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            tree = parser.typeCalculation();
        }
        catch (ParseCancellationException ex) {
            tokenStream.reset();
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            tree = parser.typeCalculation();
        }
        return tree;
    }

    private static class CalculateTypeVisitor
    extends TypeCalculationBaseVisitor<Long> {
        private final Map<String, Long> inputs;

        public CalculateTypeVisitor(Map<String, Long> inputs) {
            this.inputs = Objects.requireNonNull(inputs);
        }

        @Override
        public Long visitTypeCalculation(TypeCalculationParser.TypeCalculationContext ctx) {
            return (Long)this.visit((ParseTree)ctx.expression());
        }

        @Override
        public Long visitArithmeticBinary(TypeCalculationParser.ArithmeticBinaryContext ctx) {
            Long left = (Long)this.visit((ParseTree)ctx.left);
            Long right = (Long)this.visit((ParseTree)ctx.right);
            switch (ctx.operator.getType()) {
                case 4: {
                    return left + right;
                }
                case 5: {
                    return left - right;
                }
                case 6: {
                    return left * right;
                }
                case 7: {
                    return left / right;
                }
            }
            throw new IllegalStateException("Unsupported binary operator " + ctx.operator.getText());
        }

        @Override
        public Long visitArithmeticUnary(TypeCalculationParser.ArithmeticUnaryContext ctx) {
            Long value = (Long)this.visit((ParseTree)ctx.expression());
            switch (ctx.operator.getType()) {
                case 4: {
                    return value;
                }
                case 5: {
                    return -1L * value;
                }
            }
            throw new IllegalStateException("Unsupported unary operator " + ctx.operator.getText());
        }

        @Override
        public Long visitBinaryFunction(TypeCalculationParser.BinaryFunctionContext ctx) {
            Long left = (Long)this.visit((ParseTree)ctx.left);
            Long right = (Long)this.visit((ParseTree)ctx.right);
            switch (ctx.binaryFunctionName().name.getType()) {
                case 9: {
                    return Math.min(left, right);
                }
                case 10: {
                    return Math.max(left, right);
                }
            }
            throw new IllegalArgumentException("Unsupported binary function " + ctx.binaryFunctionName().getText());
        }

        @Override
        public Long visitNumericLiteral(TypeCalculationParser.NumericLiteralContext ctx) {
            return Long.parseLong(ctx.INTEGER_VALUE().getText());
        }

        @Override
        public Long visitNullLiteral(TypeCalculationParser.NullLiteralContext ctx) {
            return 0L;
        }

        @Override
        public Long visitIdentifier(TypeCalculationParser.IdentifierContext ctx) {
            String identifier = ctx.getText();
            Long value = this.inputs.get(identifier);
            Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is not specified in the inputs", (Object[])new Object[]{identifier});
            return value;
        }

        @Override
        public Long visitParenthesizedExpression(TypeCalculationParser.ParenthesizedExpressionContext ctx) {
            return (Long)this.visit((ParseTree)ctx.expression());
        }
    }

    private static class IsSimpleExpressionVisitor
    extends TypeCalculationBaseVisitor<Boolean> {
        private IsSimpleExpressionVisitor() {
        }

        @Override
        public Boolean visitArithmeticBinary(TypeCalculationParser.ArithmeticBinaryContext ctx) {
            return false;
        }

        @Override
        public Boolean visitArithmeticUnary(TypeCalculationParser.ArithmeticUnaryContext ctx) {
            return false;
        }

        protected Boolean defaultResult() {
            return true;
        }

        protected Boolean aggregateResult(Boolean aggregate, Boolean nextResult) {
            return aggregate != false && nextResult != false;
        }
    }
}

