/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class QualifiedName {
    private final List<String> parts;
    private final List<String> originalParts;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        return new QualifiedName((Iterable<String>)ImmutableList.copyOf((Collection)Lists.asList((Object)first, (Object[])rest)));
    }

    public QualifiedName(String name) {
        this((Iterable<String>)ImmutableList.of((Object)name));
    }

    public QualifiedName(Iterable<String> parts) {
        Objects.requireNonNull(parts, "parts is null");
        Preconditions.checkArgument((!Iterables.isEmpty(parts) ? 1 : 0) != 0, (Object)"parts is empty");
        this.parts = ImmutableList.copyOf((Iterable)Iterables.transform(parts, part -> part.toLowerCase(Locale.ENGLISH)));
        this.originalParts = ImmutableList.copyOf(parts);
    }

    public List<String> getParts() {
        return this.parts;
    }

    public List<String> getOriginalParts() {
        return this.originalParts;
    }

    public String toString() {
        return Joiner.on((char)'.').join(this.parts);
    }

    public Optional<QualifiedName> getPrefix() {
        if (this.parts.size() == 1) {
            return Optional.empty();
        }
        return Optional.of(new QualifiedName(this.parts.subList(0, this.parts.size() - 1)));
    }

    public boolean hasSuffix(QualifiedName suffix) {
        if (this.parts.size() < suffix.getParts().size()) {
            return false;
        }
        int start = this.parts.size() - suffix.getParts().size();
        return this.parts.subList(start, this.parts.size()).equals(suffix.getParts());
    }

    public String getSuffix() {
        return (String)Iterables.getLast(this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((QualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

