/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public final class Cast
extends Expression {
    private final Expression expression;
    private final String type;
    private final boolean safe;
    private final boolean typeOnly;

    public Cast(Expression expression, String type) {
        this(Optional.empty(), expression, type, false, false);
    }

    public Cast(NodeLocation location, Expression expression, String type) {
        this(Optional.of(location), expression, type, false, false);
    }

    public Cast(Expression expression, String type, boolean safe) {
        this(Optional.empty(), expression, type, safe, false);
    }

    public Cast(Expression expression, String type, boolean safe, boolean typeOnly) {
        this(Optional.empty(), expression, type, safe, typeOnly);
    }

    public Cast(NodeLocation location, Expression expression, String type, boolean safe) {
        this(Optional.of(location), expression, type, safe, false);
    }

    private Cast(Optional<NodeLocation> location, Expression expression, String type, boolean safe, boolean typeOnly) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(type, "type is null");
        this.expression = expression;
        this.type = type.toUpperCase(Locale.ENGLISH);
        this.safe = safe;
        this.typeOnly = typeOnly;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean isTypeOnly() {
        return this.typeOnly;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cast o = (Cast)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.type, o.type) && Objects.equals(this.safe, o.safe) && Objects.equals(this.typeOnly, o.typeOnly);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.safe, this.typeOnly);
    }
}

