/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;

public abstract class DefaultTraversalVisitor<R, C>
extends AstVisitor<R, C> {
    @Override
    protected R visitExtract(Extract node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitCast(Cast node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected R visitCoalesceExpression(CoalesceExpression node, C context) {
        for (Expression operand : node.getOperands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected R visitArrayConstructor(ArrayConstructor node, C context) {
        for (Expression expression : node.getValues()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    protected R visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitQuery(Query node, C context) {
        if (node.getWith().isPresent()) {
            this.process(node.getWith().get(), context);
        }
        this.process(node.getQueryBody(), context);
        for (SortItem sortItem : node.getOrderBy()) {
            this.process(sortItem, context);
        }
        return null;
    }

    @Override
    protected R visitWith(With node, C context) {
        for (WithQuery query : node.getQueries()) {
            this.process(query, context);
        }
        return null;
    }

    @Override
    protected R visitWithQuery(WithQuery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process(item, context);
        }
        return null;
    }

    @Override
    protected R visitSingleColumn(SingleColumn node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected R visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    protected R visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected R visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        if (node.getWindow().isPresent()) {
            this.process(node.getWindow().get(), context);
        }
        return null;
    }

    @Override
    protected R visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    public R visitWindow(Window node, C context) {
        for (Expression expression : node.getPartitionBy()) {
            this.process(expression, context);
        }
        for (SortItem sortItem : node.getOrderBy()) {
            this.process(sortItem.getSortKey(), context);
        }
        if (node.getFrame().isPresent()) {
            this.process(node.getFrame().get(), context);
        }
        return null;
    }

    @Override
    public R visitWindowFrame(WindowFrame node, C context) {
        this.process(node.getStart(), context);
        if (node.getEnd().isPresent()) {
            this.process(node.getEnd().get(), context);
        }
        return null;
    }

    @Override
    public R visitFrameBound(FrameBound node, C context) {
        if (node.getValue().isPresent()) {
            this.process(node.getValue().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        return null;
    }

    @Override
    protected R visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected R visitIfExpression(IfExpression node, C context) {
        this.process(node.getCondition(), context);
        this.process(node.getTrueValue(), context);
        if (node.getFalseValue().isPresent()) {
            this.process(node.getFalseValue().get(), context);
        }
        return null;
    }

    @Override
    protected R visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitNotExpression(NotExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        if (node.getEscape() != null) {
            this.process(node.getEscape(), context);
        }
        return null;
    }

    @Override
    protected R visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitIsNullPredicate(IsNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitSubqueryExpression(SubqueryExpression node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitSortItem(SortItem node, C context) {
        return this.process(node.getSortKey(), context);
    }

    @Override
    protected R visitQuerySpecification(QuerySpecification node, C context) {
        this.process(node.getSelect(), context);
        if (node.getFrom().isPresent()) {
            this.process(node.getFrom().get(), context);
        }
        if (node.getWhere().isPresent()) {
            this.process(node.getWhere().get(), context);
        }
        for (GroupingElement groupingElement : node.getGroupBy()) {
            this.process(groupingElement, context);
        }
        if (node.getHaving().isPresent()) {
            this.process(node.getHaving().get(), context);
        }
        for (SortItem sortItem : node.getOrderBy()) {
            this.process(sortItem, context);
        }
        return null;
    }

    @Override
    protected R visitUnion(Union node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process(relation, context);
        }
        return null;
    }

    @Override
    protected R visitIntersect(Intersect node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process(relation, context);
        }
        return null;
    }

    @Override
    protected R visitExcept(Except node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitValues(Values node, C context) {
        for (Expression row : node.getRows()) {
            this.process(row, context);
        }
        return null;
    }

    @Override
    protected R visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitTableSubquery(TableSubquery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitAliasedRelation(AliasedRelation node, C context) {
        return this.process(node.getRelation(), context);
    }

    @Override
    protected R visitSampledRelation(SampledRelation node, C context) {
        this.process(node.getRelation(), context);
        this.process(node.getSamplePercentage(), context);
        if (node.getColumnsToStratifyOn().isPresent()) {
            for (Expression expression : node.getColumnsToStratifyOn().get()) {
                this.process(expression, context);
            }
        }
        return null;
    }

    @Override
    protected R visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        node.getCriteria().filter(criteria -> criteria instanceof JoinOn).map(criteria -> this.process(((JoinOn)criteria).getExpression(), context));
        return null;
    }

    @Override
    protected R visitUnnest(Unnest node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }
}

