/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    public BetweenPredicate(Expression value, Expression min, Expression max) {
        this(Optional.empty(), value, min, max);
    }

    public BetweenPredicate(NodeLocation location, Expression value, Expression min, Expression max) {
        this(Optional.of(location), value, min, max);
    }

    private BetweenPredicate(Optional<NodeLocation> location, Expression value, Expression min, Expression max) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(min, "min is null");
        Objects.requireNonNull(max, "max is null");
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getMin() {
        return this.min;
    }

    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        if (!this.max.equals(that.max)) {
            return false;
        }
        if (!this.min.equals(that.min)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }
}

