/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class IsNullPredicate
extends Expression {
    private final Expression value;

    public IsNullPredicate(Expression value) {
        this(Optional.empty(), value);
    }

    public IsNullPredicate(NodeLocation location, Expression value) {
        this(Optional.of(location), value);
    }

    private IsNullPredicate(Optional<NodeLocation> location, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIsNullPredicate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsNullPredicate that = (IsNullPredicate)o;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

