/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public final class GenericLiteral
extends Literal {
    private final String type;
    private final String value;

    public GenericLiteral(String type, String value) {
        this(Optional.empty(), type, value);
    }

    public GenericLiteral(NodeLocation location, String type, String value) {
        this(Optional.of(location), type, value);
    }

    private GenericLiteral(Optional<NodeLocation> location, String type, String value) {
        super(location);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericLiteral other = (GenericLiteral)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }
}

