/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExpressionFormatter {
    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression) {
        return ExpressionFormatter.formatExpression(expression, true);
    }

    public static String formatExpression(Expression expression, boolean unmangleNames) {
        return (String)new Formatter().process(expression, unmangleNames);
    }

    static String formatStringLiteral(String s) {
        return "'" + s.replace("'", "''") + "'";
    }

    static String formatSortItems(List<SortItem> sortItems) {
        return ExpressionFormatter.formatSortItems(sortItems, true);
    }

    static String formatSortItems(List<SortItem> sortItems, boolean unmangleNames) {
        return Joiner.on((String)", ").join(sortItems.stream().map(ExpressionFormatter.sortItemFormatterFunction(unmangleNames)).iterator());
    }

    private static Function<SortItem, String> sortItemFormatterFunction(boolean unmangleNames) {
        return input -> {
            StringBuilder builder = new StringBuilder();
            builder.append(ExpressionFormatter.formatExpression(input.getSortKey(), unmangleNames));
            switch (input.getOrdering()) {
                case ASCENDING: {
                    builder.append(" ASC");
                    break;
                }
                case DESCENDING: {
                    builder.append(" DESC");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown ordering: " + (Object)((Object)input.getOrdering()));
                }
            }
            switch (input.getNullOrdering()) {
                case FIRST: {
                    builder.append(" NULLS FIRST");
                    break;
                }
                case LAST: {
                    builder.append(" NULLS LAST");
                    break;
                }
                case UNDEFINED: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown null ordering: " + (Object)((Object)input.getNullOrdering()));
                }
            }
            return builder.toString();
        };
    }

    public static class Formatter
    extends AstVisitor<String, Boolean> {
        @Override
        protected String visitNode(Node node, Boolean unmangleNames) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String visitRow(Row node, Boolean unmangleNames) {
            return "ROW (" + Joiner.on((String)", ").join((Iterable)node.getItems().stream().map(child -> (String)this.process((Node)child, unmangleNames)).collect(Collectors.toList())) + ")";
        }

        @Override
        protected String visitExpression(Expression node, Boolean unmangleNames) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", this.getClass().getName(), node.getClass().getSimpleName()));
        }

        @Override
        protected String visitCurrentTime(CurrentTime node, Boolean unmangleNames) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().getName());
            if (node.getPrecision() != null) {
                builder.append('(').append(node.getPrecision()).append(')');
            }
            return builder.toString();
        }

        @Override
        protected String visitExtract(Extract node, Boolean unmangleNames) {
            return "EXTRACT(" + (Object)((Object)node.getField()) + " FROM " + (String)this.process(node.getExpression(), unmangleNames) + ")";
        }

        @Override
        protected String visitBooleanLiteral(BooleanLiteral node, Boolean unmangleNames) {
            return String.valueOf(node.getValue());
        }

        @Override
        protected String visitStringLiteral(StringLiteral node, Boolean unmangleNames) {
            return ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        @Override
        protected String visitArrayConstructor(ArrayConstructor node, Boolean unmangleNames) {
            ImmutableList.Builder valueStrings = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                valueStrings.add((Object)SqlFormatter.formatSql(value, unmangleNames));
            }
            return "ARRAY[" + Joiner.on((String)",").join((Iterable)valueStrings.build()) + "]";
        }

        @Override
        protected String visitSubscriptExpression(SubscriptExpression node, Boolean unmangleNames) {
            return SqlFormatter.formatSql(node.getBase(), unmangleNames) + "[" + SqlFormatter.formatSql(node.getIndex(), unmangleNames) + "]";
        }

        @Override
        protected String visitLongLiteral(LongLiteral node, Boolean unmangleNames) {
            return Long.toString(node.getValue());
        }

        @Override
        protected String visitDoubleLiteral(DoubleLiteral node, Boolean unmangleNames) {
            return Double.toString(node.getValue());
        }

        @Override
        protected String visitGenericLiteral(GenericLiteral node, Boolean unmangleNames) {
            return node.getType() + " '" + node.getValue() + "'";
        }

        @Override
        protected String visitTimeLiteral(TimeLiteral node, Boolean unmangleNames) {
            return "TIME '" + node.getValue() + "'";
        }

        @Override
        protected String visitTimestampLiteral(TimestampLiteral node, Boolean unmangleNames) {
            return "TIMESTAMP '" + node.getValue() + "'";
        }

        @Override
        protected String visitNullLiteral(NullLiteral node, Boolean unmangleNames) {
            return "null";
        }

        @Override
        protected String visitIntervalLiteral(IntervalLiteral node, Boolean unmangleNames) {
            String sign = node.getSign() == IntervalLiteral.Sign.NEGATIVE ? "- " : "";
            StringBuilder builder = new StringBuilder().append("INTERVAL ").append(sign).append(" '").append(node.getValue()).append("' ").append((Object)node.getStartField());
            if (node.getEndField().isPresent()) {
                builder.append(" TO ").append((Object)node.getEndField().get());
            }
            return builder.toString();
        }

        @Override
        protected String visitSubqueryExpression(SubqueryExpression node, Boolean unmangleNames) {
            return "(" + SqlFormatter.formatSql(node.getQuery(), unmangleNames) + ")";
        }

        @Override
        protected String visitExists(ExistsPredicate node, Boolean unmangleNames) {
            return "EXISTS (" + SqlFormatter.formatSql(node.getSubquery(), unmangleNames) + ")";
        }

        @Override
        protected String visitQualifiedNameReference(QualifiedNameReference node, Boolean unmangleNames) {
            return Formatter.formatQualifiedName(node.getName());
        }

        @Override
        protected String visitDereferenceExpression(DereferenceExpression node, Boolean unmangleNames) {
            String baseString = (String)this.process(node.getBase(), unmangleNames);
            return baseString + "." + Formatter.formatIdentifier(node.getFieldName());
        }

        private static String formatQualifiedName(QualifiedName name) {
            ArrayList<String> parts = new ArrayList<String>();
            for (String part : name.getParts()) {
                parts.add(Formatter.formatIdentifier(part));
            }
            return Joiner.on((char)'.').join(parts);
        }

        @Override
        public String visitInputReference(InputReference node, Boolean unmangleNames) {
            return ":input(" + node.getChannel() + ")";
        }

        @Override
        protected String visitFunctionCall(FunctionCall node, Boolean unmangleNames) {
            StringBuilder builder = new StringBuilder();
            String arguments = this.joinExpressions(node.getArguments(), unmangleNames);
            if (node.getArguments().isEmpty() && "count".equalsIgnoreCase(node.getName().getSuffix())) {
                arguments = "*";
            }
            if (node.isDistinct()) {
                arguments = "DISTINCT " + arguments;
            }
            if (unmangleNames.booleanValue() && node.getName().toString().startsWith("$field_reference$")) {
                Preconditions.checkState((node.getArguments().size() == 1 ? 1 : 0) != 0, (Object)"Expected only one argument to field reference");
                QualifiedName name = QualifiedName.of(QueryUtil.unmangleFieldReference(node.getName().toString()), new String[0]);
                builder.append(arguments).append(".").append(name);
            } else {
                builder.append(Formatter.formatQualifiedName(node.getName())).append('(').append(arguments).append(')');
            }
            if (node.getWindow().isPresent()) {
                builder.append(" OVER ").append(this.visitWindow(node.getWindow().get(), unmangleNames));
            }
            return builder.toString();
        }

        @Override
        protected String visitLogicalBinaryExpression(LogicalBinaryExpression node, Boolean unmangleNames) {
            return this.formatBinaryExpression(node.getType().toString(), node.getLeft(), node.getRight(), unmangleNames);
        }

        @Override
        protected String visitNotExpression(NotExpression node, Boolean unmangleNames) {
            return "(NOT " + (String)this.process(node.getValue(), unmangleNames) + ")";
        }

        @Override
        protected String visitComparisonExpression(ComparisonExpression node, Boolean unmangleNames) {
            return this.formatBinaryExpression(node.getType().getValue(), node.getLeft(), node.getRight(), unmangleNames);
        }

        @Override
        protected String visitIsNullPredicate(IsNullPredicate node, Boolean unmangleNames) {
            return "(" + (String)this.process(node.getValue(), unmangleNames) + " IS NULL)";
        }

        @Override
        protected String visitIsNotNullPredicate(IsNotNullPredicate node, Boolean unmangleNames) {
            return "(" + (String)this.process(node.getValue(), unmangleNames) + " IS NOT NULL)";
        }

        @Override
        protected String visitNullIfExpression(NullIfExpression node, Boolean unmangleNames) {
            return "NULLIF(" + (String)this.process(node.getFirst(), unmangleNames) + ", " + (String)this.process(node.getSecond(), unmangleNames) + ')';
        }

        @Override
        protected String visitIfExpression(IfExpression node, Boolean unmangleNames) {
            StringBuilder builder = new StringBuilder();
            builder.append("IF(").append((String)this.process(node.getCondition(), unmangleNames)).append(", ").append((String)this.process(node.getTrueValue(), unmangleNames));
            if (node.getFalseValue().isPresent()) {
                builder.append(", ").append((String)this.process(node.getFalseValue().get(), unmangleNames));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String visitCoalesceExpression(CoalesceExpression node, Boolean unmangleNames) {
            return "COALESCE(" + this.joinExpressions(node.getOperands(), unmangleNames) + ")";
        }

        @Override
        protected String visitArithmeticUnary(ArithmeticUnaryExpression node, Boolean unmangleNames) {
            String value = (String)this.process(node.getValue(), unmangleNames);
            switch (node.getSign()) {
                case MINUS: {
                    String separator = value.startsWith("-") ? " " : "";
                    return "-" + separator + value;
                }
                case PLUS: {
                    return "+" + value;
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + (Object)((Object)node.getSign()));
        }

        @Override
        protected String visitArithmeticBinary(ArithmeticBinaryExpression node, Boolean unmangleNames) {
            return this.formatBinaryExpression(node.getType().getValue(), node.getLeft(), node.getRight(), unmangleNames);
        }

        @Override
        protected String visitLikePredicate(LikePredicate node, Boolean unmangleNames) {
            StringBuilder builder = new StringBuilder();
            builder.append('(').append((String)this.process(node.getValue(), unmangleNames)).append(" LIKE ").append((String)this.process(node.getPattern(), unmangleNames));
            if (node.getEscape() != null) {
                builder.append(" ESCAPE ").append((String)this.process(node.getEscape(), unmangleNames));
            }
            builder.append(')');
            return builder.toString();
        }

        @Override
        protected String visitAllColumns(AllColumns node, Boolean unmangleNames) {
            if (node.getPrefix().isPresent()) {
                return node.getPrefix().get() + ".*";
            }
            return "*";
        }

        @Override
        public String visitCast(Cast node, Boolean unmangleNames) {
            return (node.isSafe() ? "TRY_CAST" : "CAST") + "(" + (String)this.process(node.getExpression(), unmangleNames) + " AS " + node.getType() + ")";
        }

        @Override
        protected String visitSearchedCaseExpression(SearchedCaseExpression node, Boolean unmangleNames) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, unmangleNames));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Node)value, unmangleNames)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitSimpleCaseExpression(SimpleCaseExpression node, Boolean unmangleNames) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add(this.process(node.getOperand(), unmangleNames));
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, unmangleNames));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Node)value, unmangleNames)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitWhenClause(WhenClause node, Boolean unmangleNames) {
            return "WHEN " + (String)this.process(node.getOperand(), unmangleNames) + " THEN " + (String)this.process(node.getResult(), unmangleNames);
        }

        @Override
        protected String visitBetweenPredicate(BetweenPredicate node, Boolean unmangleNames) {
            return "(" + (String)this.process(node.getValue(), unmangleNames) + " BETWEEN " + (String)this.process(node.getMin(), unmangleNames) + " AND " + (String)this.process(node.getMax(), unmangleNames) + ")";
        }

        @Override
        protected String visitInPredicate(InPredicate node, Boolean unmangleNames) {
            return "(" + (String)this.process(node.getValue(), unmangleNames) + " IN " + (String)this.process(node.getValueList(), unmangleNames) + ")";
        }

        @Override
        protected String visitInListExpression(InListExpression node, Boolean unmangleNames) {
            return "(" + this.joinExpressions(node.getValues(), unmangleNames) + ")";
        }

        @Override
        public String visitWindow(Window node, Boolean unmangleNames) {
            ArrayList<String> parts = new ArrayList<String>();
            if (!node.getPartitionBy().isEmpty()) {
                parts.add("PARTITION BY " + this.joinExpressions(node.getPartitionBy(), unmangleNames));
            }
            if (!node.getOrderBy().isEmpty()) {
                parts.add("ORDER BY " + ExpressionFormatter.formatSortItems(node.getOrderBy(), unmangleNames));
            }
            if (node.getFrame().isPresent()) {
                parts.add((String)this.process(node.getFrame().get(), unmangleNames));
            }
            return '(' + Joiner.on((char)' ').join(parts) + ')';
        }

        @Override
        public String visitWindowFrame(WindowFrame node, Boolean unmangleNames) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().toString()).append(' ');
            if (node.getEnd().isPresent()) {
                builder.append("BETWEEN ").append((String)this.process(node.getStart(), unmangleNames)).append(" AND ").append((String)this.process(node.getEnd().get(), unmangleNames));
            } else {
                builder.append((String)this.process(node.getStart(), unmangleNames));
            }
            return builder.toString();
        }

        @Override
        public String visitFrameBound(FrameBound node, Boolean unmangleNames) {
            switch (node.getType()) {
                case UNBOUNDED_PRECEDING: {
                    return "UNBOUNDED PRECEDING";
                }
                case PRECEDING: {
                    return (String)this.process(node.getValue().get(), unmangleNames) + " PRECEDING";
                }
                case CURRENT_ROW: {
                    return "CURRENT ROW";
                }
                case FOLLOWING: {
                    return (String)this.process(node.getValue().get(), unmangleNames) + " FOLLOWING";
                }
                case UNBOUNDED_FOLLOWING: {
                    return "UNBOUNDED FOLLOWING";
                }
            }
            throw new IllegalArgumentException("unhandled type: " + (Object)((Object)node.getType()));
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right, boolean unmangleNames) {
            return '(' + (String)this.process(left, unmangleNames) + ' ' + operator + ' ' + (String)this.process(right, unmangleNames) + ')';
        }

        private String joinExpressions(List<Expression> expressions, boolean unmangleNames) {
            return Joiner.on((String)", ").join(expressions.stream().map(e -> (String)this.process((Node)e, unmangleNames)).iterator());
        }

        private static String formatIdentifier(String s) {
            return '\"' + s + '\"';
        }
    }
}

